/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geronimo.clustering.Cluster;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.Session;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.clustering.SessionManagerListener;
import org.apache.geronimo.clustering.wadi.ClusteredServiceHolder;
import org.apache.geronimo.clustering.wadi.RemoteNode;
import org.apache.geronimo.clustering.wadi.WADICluster;
import org.apache.geronimo.clustering.wadi.WADISessionAdaptor;
import org.apache.geronimo.clustering.wadi.WADISessionManager;
import org.apache.geronimo.clustering.wadi.WADISessionManagerConfigInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.codehaus.wadi.aop.replication.AOPStackContext;
import org.codehaus.wadi.core.assembler.StackContext;
import org.codehaus.wadi.core.manager.Manager;
import org.codehaus.wadi.core.manager.SessionMonitor;
import org.codehaus.wadi.group.Dispatcher;
import org.codehaus.wadi.group.Peer;
import org.codehaus.wadi.replication.strategy.BackingStrategyFactory;
import org.codehaus.wadi.servicespace.LifecycleState;
import org.codehaus.wadi.servicespace.ServiceAlreadyRegisteredException;
import org.codehaus.wadi.servicespace.ServiceRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.codehaus.wadi.servicespace.ServiceSpaceLifecycleEvent;
import org.codehaus.wadi.servicespace.ServiceSpaceListener;
import org.codehaus.wadi.servicespace.ServiceSpaceName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicWADISessionManager
implements GBeanLifecycle,
SessionManager,
WADISessionManager {
    private static final Logger log = LoggerFactory.getLogger(BasicWADISessionManager.class);
    protected final ClassLoader cl;
    private final WADICluster cluster;
    protected final WADISessionManagerConfigInfo configInfo;
    protected final BackingStrategyFactory backingStrategyFactory;
    private final Collection<ClusteredServiceHolder> serviceHolders;
    private final CopyOnWriteArrayList<SessionListener> listeners;
    private final Map<SessionManagerListener, ServiceSpaceListener> sessionManagerListenerToAdapter;
    private Manager manager;
    private SessionMonitor sessionMonitor;
    private ServiceSpace serviceSpace;
    public static final String GBEAN_ATTR_WADI_CONFIG_INFO = "wadiConfigInfo";
    public static final String GBEAN_REF_CLUSTER = "Cluster";
    public static final String GBEAN_REF_BACKING_STRATEGY_FACTORY = "BackingStrategyFactory";
    public static final String GBEAN_REF_SERVICE_HOLDERS = "ServiceHolders";

    public BasicWADISessionManager(@ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader cl, @ParamAttribute(name="wadiConfigInfo") WADISessionManagerConfigInfo configInfo, @ParamReference(name="Cluster") WADICluster cluster, @ParamReference(name="BackingStrategyFactory") BackingStrategyFactory backingStrategyFactory, @ParamReference(name="ServiceHolders") Collection<ClusteredServiceHolder> serviceHolders) {
        if (null == cl) {
            throw new IllegalArgumentException("cl is required");
        }
        if (null == configInfo) {
            throw new IllegalArgumentException("configInfo is required");
        }
        if (null == cluster) {
            throw new IllegalArgumentException("cluster is required");
        }
        if (null == backingStrategyFactory) {
            throw new IllegalArgumentException("backingStrategyFactory is required");
        }
        this.cl = cl;
        this.configInfo = configInfo;
        this.cluster = cluster;
        this.backingStrategyFactory = backingStrategyFactory;
        if (null == serviceHolders) {
            serviceHolders = Collections.emptySet();
        }
        this.serviceHolders = serviceHolders;
        this.listeners = new CopyOnWriteArrayList();
        this.sessionManagerListenerToAdapter = new HashMap<SessionManagerListener, ServiceSpaceListener>();
    }

    public void doStart() throws Exception {
        Dispatcher underlyingDisp = this.cluster.getCluster().getDispatcher();
        ServiceSpaceName serviceSpaceName = new ServiceSpaceName(this.configInfo.getServiceSpaceURI());
        Object stackContext = this.configInfo.isDeltaReplication() ? this.newAOPStackContext(underlyingDisp, serviceSpaceName) : this.newStackContext(underlyingDisp, serviceSpaceName);
        stackContext.setDisableReplication(this.configInfo.isDisableReplication());
        stackContext.build();
        this.serviceSpace = stackContext.getServiceSpace();
        this.manager = stackContext.getManager();
        this.sessionMonitor = stackContext.getSessionMonitor();
        this.sessionMonitor.addSessionListener((org.codehaus.wadi.core.manager.SessionListener)new SessionListenerAdapter());
        this.registerClusteredServices();
        this.serviceSpace.start();
    }

    public void doStop() throws Exception {
        this.serviceSpace.stop();
    }

    public void doFail() {
        try {
            this.serviceSpace.stop();
        }
        catch (Exception e) {
            log.error("Failed to stop", (Throwable)e);
        }
    }

    public Session createSession(String sessionId) throws SessionAlreadyExistException {
        org.codehaus.wadi.core.session.Session session;
        try {
            session = this.manager.createWithName(sessionId);
        }
        catch (org.codehaus.wadi.core.manager.SessionAlreadyExistException e) {
            throw new SessionAlreadyExistException("Session " + sessionId + " already exists", (Throwable)e);
        }
        return new WADISessionAdaptor(session);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Node getNode() {
        return this.cluster.getLocalNode();
    }

    public Set<Node> getRemoteNodes() {
        Set peers = this.serviceSpace.getHostingPeers();
        return this.mapToNodes(peers);
    }

    public void registerListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSessionManagerListener(SessionManagerListener listener) {
        ServiceSpaceListenerAdapter adapter = new ServiceSpaceListenerAdapter(listener);
        this.serviceSpace.addServiceSpaceListener((ServiceSpaceListener)adapter);
        Map<SessionManagerListener, ServiceSpaceListener> map = this.sessionManagerListenerToAdapter;
        synchronized (map) {
            this.sessionManagerListenerToAdapter.put(listener, adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSessionManagerListener(SessionManagerListener listener) {
        ServiceSpaceListener adapter;
        Map<SessionManagerListener, ServiceSpaceListener> map = this.sessionManagerListenerToAdapter;
        synchronized (map) {
            adapter = this.sessionManagerListenerToAdapter.remove(listener);
        }
        if (null == adapter) {
            throw new IllegalArgumentException("Listener [" + listener + "] is not registered");
        }
        this.serviceSpace.removeServiceSpaceListener(adapter);
    }

    @Override
    public ServiceSpace getServiceSpace() {
        return this.serviceSpace;
    }

    protected StackContext newStackContext(Dispatcher underlyingDisp, ServiceSpaceName serviceSpaceName) {
        return new StackContext(this.cl, serviceSpaceName, underlyingDisp, this.configInfo.getSessionTimeoutSeconds(), this.configInfo.getNumPartitions(), this.configInfo.getSweepInterval(), this.backingStrategyFactory);
    }

    protected AOPStackContext newAOPStackContext(Dispatcher underlyingDisp, ServiceSpaceName serviceSpaceName) {
        return new AOPStackContext(this.cl, serviceSpaceName, underlyingDisp, this.configInfo.getSessionTimeoutSeconds(), this.configInfo.getNumPartitions(), this.configInfo.getSweepInterval(), this.backingStrategyFactory);
    }

    protected void registerClusteredServices() throws ServiceAlreadyRegisteredException {
        ServiceRegistry serviceRegistry = this.serviceSpace.getServiceRegistry();
        for (ClusteredServiceHolder serviceHolder : this.serviceHolders) {
            serviceRegistry.register(serviceHolder.getServiceName(), serviceHolder.getService());
        }
    }

    protected Set<Node> mapToNodes(Set<Peer> peers) throws AssertionError {
        HashSet<Node> nodes = new HashSet<Node>();
        for (Peer peer : peers) {
            RemoteNode remoteNode = RemoteNode.retrieveAdaptor(peer);
            nodes.add((Node)remoteNode);
        }
        return nodes;
    }

    protected Node mapToNode(Peer peer) throws AssertionError {
        return RemoteNode.retrieveAdaptor(peer);
    }

    protected void notifyInboundSessionMigration(org.codehaus.wadi.core.session.Session session) {
        for (SessionListener listener : this.listeners) {
            listener.notifyInboundSessionMigration((Session)new WADISessionAdaptor(session));
        }
    }

    protected void notifyOutboundSessionMigration(org.codehaus.wadi.core.session.Session session) {
        for (SessionListener listener : this.listeners) {
            WADISessionAdaptor adaptor = WADISessionAdaptor.retrieveAdaptor(session);
            listener.notifyOutboundSessionMigration((Session)adaptor);
        }
    }

    protected void notifySessionDestruction(org.codehaus.wadi.core.session.Session session) {
        for (SessionListener listener : this.listeners) {
            WADISessionAdaptor adaptor = WADISessionAdaptor.retrieveAdaptor(session);
            listener.notifySessionDestruction((Session)adaptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ServiceSpaceListenerAdapter
    implements ServiceSpaceListener {
        private final SessionManagerListener listener;

        public ServiceSpaceListenerAdapter(SessionManagerListener listener) {
            this.listener = listener;
        }

        public void receive(ServiceSpaceLifecycleEvent event, Set<Peer> newHostingPeers) {
            LifecycleState state = event.getState();
            if (state == LifecycleState.STARTED) {
                Set<Node> newHostingNodes = BasicWADISessionManager.this.mapToNodes(newHostingPeers);
                Node joiningNode = BasicWADISessionManager.this.mapToNode(event.getHostingPeer());
                this.listener.onJoin(joiningNode, newHostingNodes);
            } else if (state == LifecycleState.STOPPED || state == LifecycleState.FAILED) {
                Set<Node> newHostingNodes = BasicWADISessionManager.this.mapToNodes(newHostingPeers);
                Node leavingNode = BasicWADISessionManager.this.mapToNode(event.getHostingPeer());
                this.listener.onLeave(leavingNode, newHostingNodes);
            }
        }
    }

    protected class SessionListenerAdapter
    implements org.codehaus.wadi.core.manager.SessionListener {
        protected SessionListenerAdapter() {
        }

        public void onSessionCreation(org.codehaus.wadi.core.session.Session session) {
        }

        public void onSessionDestruction(org.codehaus.wadi.core.session.Session session) {
            BasicWADISessionManager.this.notifySessionDestruction(session);
        }

        public void onInboundSessionMigration(org.codehaus.wadi.core.session.Session session) {
            BasicWADISessionManager.this.notifyInboundSessionMigration(session);
        }

        public void onOutbountSessionMigration(org.codehaus.wadi.core.session.Session session) {
            BasicWADISessionManager.this.notifyOutboundSessionMigration(session);
        }
    }
}

