/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class GeronimoPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    protected String resolveSystemProperty(String placeholder) {
        String sPropertyValue = super.resolveSystemProperty(placeholder);
        if (sPropertyValue == null && (sPropertyValue = this.parseSystemProperty(placeholder)) == null) {
            sPropertyValue = this.parseEnvProperty(placeholder);
        }
        return sPropertyValue;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String sPropertyValue = super.resolvePlaceholder(placeholder, props);
        if (sPropertyValue == null) {
            try {
                Expression expression = ExpressionFactory.createExpression((String)placeholder);
                JexlContext jexlContext = JexlHelper.createContext();
                jexlContext.setVars((Map)props);
                sPropertyValue = expression.evaluate(jexlContext).toString();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return sPropertyValue;
    }

    private String parseSystemProperty(String placeholder) {
        try {
            Expression expression = ExpressionFactory.createExpression((String)placeholder);
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.setVars((Map)System.getProperties());
            return expression.evaluate(jexlContext).toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String parseEnvProperty(String placeholder) {
        try {
            Expression expression = ExpressionFactory.createExpression((String)placeholder);
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.setVars(System.getenv());
            return expression.evaluate(jexlContext).toString();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

