/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.microprofile.zipkin;

import java.util.logging.Logger;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.apache.geronimo.microprofile.opentracing.common.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.zipkin.ZipkinSpan;
import org.apache.geronimo.microprofile.opentracing.common.spi.Listener;

public class ZipkinLogger
implements Listener<ZipkinSpan> {
    private final Logger spanLogger = Logger.getLogger("org.apache.geronimo.opentracing.zipkin");
    private GeronimoOpenTracingConfig config;
    private Jsonb jsonb;
    private boolean wrapAsList;

    public void setConfig(GeronimoOpenTracingConfig config) {
        this.config = config;
    }

    public void setJsonb(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public void init() {
        if (this.jsonb == null) {
            this.jsonb = JsonbBuilder.create();
        }
        this.wrapAsList = Boolean.parseBoolean(this.config.read("span.converter.zipkin.logger.wrapAsList", "true"));
    }

    public Jsonb getJsonb() {
        return this.jsonb;
    }

    public void destroy() {
        try {
            this.jsonb.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onEvent(ZipkinSpan zipkinSpan) {
        String json = this.jsonb.toJson((Object)zipkinSpan);
        this.spanLogger.info(this.wrapAsList ? '[' + json + ']' : json);
    }
}

