/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.microprofile.server;

import io.opentracing.Tracer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.apache.geronimo.microprofile.opentracing.common.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.server.OpenTracingServerRequestFilter;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.server.OpenTracingServerResponseFilter;
import org.apache.geronimo.microprofile.opentracing.common.spi.Container;
import org.eclipse.microprofile.opentracing.Traced;

@Provider
public class GeronimoOpenTracingFeature
implements DynamicFeature {
    private Tracer tracer;
    private GeronimoOpenTracingConfig config;
    private Container container;
    private Collection<Pattern> skipPatterns;
    private String globalFilterRequestSkip;
    private boolean globalIgnoreMetadataResources;

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void setConfig(GeronimoOpenTracingConfig config) {
        this.config = config;
        this.globalFilterRequestSkip = config.read("server.filter.request.skip", "false");
        this.globalIgnoreMetadataResources = Boolean.parseBoolean(config.read("server.filter.request.ignoreMetadaResources", "true"));
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Optional<Traced> traced;
        if ((this.tracer == null || this.config == null) && this.container == null) {
            this.container = Container.get();
        }
        if (this.tracer == null) {
            this.tracer = this.container.lookup(Tracer.class);
        }
        if (this.config == null) {
            this.config = this.container.lookup(GeronimoOpenTracingConfig.class);
        }
        if (this.skipPatterns == null) {
            this.skipPatterns = Optional.ofNullable(this.config.read("mp.opentracing.server.skip-pattern", null)).map(it -> Stream.of(it.split("\\|")).map(String::trim).filter(p -> !p.isEmpty()).map(Pattern::compile).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        }
        if (!(traced = Optional.ofNullable(Optional.ofNullable(resourceInfo.getResourceMethod().getAnnotation(Traced.class)).orElseGet(() -> resourceInfo.getResourceClass().getAnnotation(Traced.class)))).map(Traced::value).orElse(true).booleanValue()) {
            return;
        }
        String path = Stream.of(Optional.ofNullable(resourceInfo.getResourceClass().getAnnotation(Path.class)).map(Path::value).orElse(""), Optional.ofNullable(resourceInfo.getResourceMethod().getAnnotation(Path.class)).map(Path::value).orElse("")).map(it -> it.substring(it.startsWith("/") ? 1 : 0, it.endsWith("/") ? it.length() - 1 : it.length())).filter(it -> !it.isEmpty()).collect(Collectors.joining("/", "/", ""));
        if (this.skipPatterns.stream().anyMatch(it -> it.matcher(path).matches())) {
            return;
        }
        String operationName = traced.map(Traced::operationName).filter(v -> !v.trim().isEmpty()).orElseGet(() -> {
            if (Boolean.parseBoolean(this.config.read("server.filter.request.operationName.usePath", "false"))) {
                return this.getHttpMethod(resourceInfo) + ':' + this.getMethodPath(resourceInfo);
            }
            if ("http-path".equals(this.config.read("mp.opentracing.server.operation-name-provider", null))) {
                return this.getMethodPath(resourceInfo);
            }
            return this.buildDefaultName(resourceInfo);
        });
        ((FeatureContext)context.register((Object)new OpenTracingServerResponseFilter())).register((Object)new OpenTracingServerRequestFilter(operationName, this.tracer, this.shouldSkip(resourceInfo), Boolean.parseBoolean(this.config.read("server.filter.request.skipDefaultTags", "false"))));
    }

    private boolean shouldSkip(ResourceInfo resourceInfo) {
        if (Boolean.parseBoolean(this.config.read("server.filter.request.skip." + resourceInfo.getResourceClass().getName() + "_" + resourceInfo.getResourceMethod().getName(), this.config.read("server.filter.request.skip." + resourceInfo.getResourceClass().getName(), this.globalFilterRequestSkip)))) {
            return true;
        }
        return this.globalIgnoreMetadataResources && this.isMetadataResource(resourceInfo.getResourceClass().getName());
    }

    private boolean isMetadataResource(String name) {
        return name.startsWith("org.apache.geronimo.microprofile.openapi.jaxrs.") || name.startsWith("org.apache.geronimo.microprofile.metrics.jaxrs.") || name.startsWith("org.apache.geronimo.microprofile.impl.health.jaxrs.") || name.startsWith("org.apache.geronimo.microprofile.reporter.storage.front.") || name.startsWith("org.microprofileext.openapi.swaggerui.");
    }

    private String getMethodPath(ResourceInfo resourceInfo) {
        String classPath = Optional.ofNullable(resourceInfo.getResourceClass().getAnnotation(Path.class)).map(Path::value).orElse("");
        String methodPath = Optional.ofNullable(resourceInfo.getResourceMethod().getAnnotation(Path.class)).map(Path::value).orElse("");
        return Stream.of(classPath, methodPath).map(it -> it.substring(it.startsWith("/") ? 1 : 0, it.length() - (it.endsWith("/") ? 1 : 0))).filter(it -> !it.isEmpty()).collect(Collectors.joining("/", "/", ""));
    }

    private String buildDefaultName(ResourceInfo resourceInfo) {
        return this.getHttpMethod(resourceInfo) + ':' + resourceInfo.getResourceClass().getName() + "." + resourceInfo.getResourceMethod().getName();
    }

    private String getHttpMethod(ResourceInfo resourceInfo) {
        return Stream.of(resourceInfo.getResourceMethod().getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(HttpMethod.class)).findFirst().map(a -> a.annotationType().getAnnotation(HttpMethod.class).value()).orElse("");
    }
}

