/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.microprofile.client;

import io.opentracing.Tracer;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.ClientBuilder;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.client.OpenTracingClientRequestFilter;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.client.OpenTracingClientResponseFilter;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.client.SyncExecutor;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.thread.OpenTracingExecutorService;
import org.apache.geronimo.microprofile.opentracing.common.spi.Container;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrarProvider;

public class GeronimoClientTracingRegistrarProvider
implements ClientTracingRegistrarProvider {
    private final OpenTracingClientRequestFilter requestFilter;
    private final OpenTracingClientResponseFilter responseFilter;
    private final Tracer tracer;

    public GeronimoClientTracingRegistrarProvider() {
        Container container = Container.get();
        this.requestFilter = container.lookup(OpenTracingClientRequestFilter.class);
        this.responseFilter = container.lookup(OpenTracingClientResponseFilter.class);
        this.tracer = container.lookup(Tracer.class);
    }

    public ClientBuilder configure(ClientBuilder builder) {
        return this.configure(builder, new SyncExecutor());
    }

    public ClientBuilder configure(ClientBuilder builder, ExecutorService executorService) {
        if (builder.getConfiguration().getInstances().stream().anyMatch(it -> this.requestFilter == it)) {
            return builder;
        }
        return ((ClientBuilder)((ClientBuilder)builder.register((Object)this.requestFilter)).register((Object)this.responseFilter)).executorService(this.wrapExecutor(executorService));
    }

    private ExecutorService wrapExecutor(ExecutorService executorService) {
        if (OpenTracingExecutorService.class.isInstance(executorService)) {
            return executorService;
        }
        return new OpenTracingExecutorService(executorService, this.tracer);
    }
}

