/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.impl;

import io.opentracing.propagation.TextMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletHeaderTextMap
implements TextMap {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ServletHeaderTextMap(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        final Enumeration iterator = this.request.getHeaderNames();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasMoreElements();
            }

            @Override
            public Map.Entry<String, String> next() {
                final String next = (String)iterator.nextElement();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return next;
                    }

                    @Override
                    public String getValue() {
                        return String.valueOf(ServletHeaderTextMap.this.request.getHeader(next));
                    }

                    @Override
                    public String setValue(String value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void put(String key, String value) {
        this.response.setHeader(key, value);
    }
}

