/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.mojo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.apache.geronimo.microprofile.openapi.impl.model.InfoImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.OpenAPIImpl;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotationProcessor;
import org.apache.geronimo.microprofile.openapi.impl.processor.reflect.ClassElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.reflect.MethodElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.spi.NamingStrategy;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;

@Mojo(name="openapi.json", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class OpenAPIMojo
extends AbstractMojo {
    @Parameter(property="geronimo-openapi.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="geronimo-openapi.prettify", defaultValue="true")
    protected boolean prettify;
    @Parameter(property="geronimo-openapi.output", defaultValue="${project.build.outputDirectory}/META-INF/classes/openapi.json")
    protected File output;
    @Parameter
    protected String application;
    @Parameter
    protected Collection<String> endpointClasses;
    @Parameter
    protected Map<String, String> configuration;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classes;
    @Parameter(property="geronimo-openapi.operationNamingStrategy", defaultValue="org.apache.geronimo.microprofile.openapi.impl.processor.spi.NamingStrategy$Default")
    protected String operationNamingStrategy;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    protected InfoImpl info;

    public void execute() throws MojoExecutionException {
        Throwable throwable;
        if (this.skip) {
            this.getLog().warn((CharSequence)"Execution is skipped");
            return;
        }
        OpenAPIImpl api = new OpenAPIImpl();
        final Thread thread = Thread.currentThread();
        final ClassLoader pluginLoader = thread.getContextClassLoader();
        try {
            throwable = null;
            try (URLClassLoader loader = new URLClassLoader((URL[])Stream.concat(Stream.of(this.classes), Optional.ofNullable(this.project).map(p -> p.getArtifacts().stream().map(Artifact::getFile)).orElseGet(Stream::empty)).filter(Objects::nonNull).map(file -> {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }).toArray(URL[]::new), pluginLoader){
                {
                    super(x0, x1);
                    thread.setContextClassLoader(this);
                }

                @Override
                public void close() throws IOException {
                    thread.setContextClassLoader(pluginLoader);
                    super.close();
                }
            };){
                AnnotationProcessor processor = new AnnotationProcessor((value, def) -> Optional.ofNullable(this.configuration).orElseGet(Collections::emptyMap).getOrDefault(value, def), this.loadNamingStrategy(), null);
                if (this.application != null) {
                    processor.processApplication((OpenAPI)api, (AnnotatedElement)new ClassElement(this.load(this.application)));
                    this.getLog().info((CharSequence)("Processed application " + this.application));
                }
                if (this.endpointClasses != null) {
                    String binding = this.application == null ? "" : processor.getApplicationBinding(this.load(this.application));
                    this.endpointClasses.stream().map(this::load).peek(c -> this.getLog().info((CharSequence)("Processing class " + c.getName()))).forEach(c -> processor.processClass(binding, (OpenAPI)api, (AnnotatedElement)new ClassElement(c), Stream.of(c.getMethods()).map(MethodElement::new)));
                } else {
                    this.getLog().warn((CharSequence)"No <endpointClasses> registered, your OpenAPI will be empty.");
                }
            }
            catch (Throwable processor) {
                throwable = processor;
                throw processor;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.info == null) {
            this.info = new InfoImpl();
        }
        if (this.info.getVersion() == null) {
            this.info.setVersion(this.project.getVersion());
        }
        if (this.info.getTitle() == null) {
            this.info.setTitle(this.project.getName());
        }
        if (this.info.getDescription() == null) {
            this.info.setDescription(this.project.getDescription());
        }
        api.info((Info)this.info);
        this.output.getParentFile().mkdirs();
        try {
            throwable = null;
            try (Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(this.prettify)));
                 FileWriter writer = new FileWriter(this.output);){
                jsonb.toJson((Object)api, (Writer)writer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        this.getLog().info((CharSequence)("Wrote " + this.output));
    }

    private NamingStrategy loadNamingStrategy() {
        return Optional.ofNullable(this.operationNamingStrategy).map(String::trim).filter(it -> !it.isEmpty()).map(it -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)it).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalArgumentException(ite.getTargetException());
            }
        }).map(NamingStrategy.class::cast).orElseGet(NamingStrategy.Default::new);
    }

    private Class<?> load(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name.trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("'" + name + "' can't be loaded", e);
        }
    }
}

