/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.processor.spi;

import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedMethodElement;

public interface NamingStrategy {
    public String name(Context var1);

    public static class Http
    implements NamingStrategy {
        @Override
        public String name(Context ctx) {
            return ctx.httpVerb + ':' + ctx.path;
        }
    }

    public static class Qualified
    implements NamingStrategy {
        @Override
        public String name(Context ctx) {
            return ctx.method.getDeclaringClass().getName() + '.' + ctx.method.getName();
        }
    }

    public static class SimpleQualifiedCamelCase
    implements NamingStrategy {
        @Override
        public String name(Context ctx) {
            String method = ctx.method.getName();
            return ctx.method.getDeclaringClass().getSimpleName() + Character.toUpperCase(method.charAt(0)) + method.substring(1);
        }
    }

    public static class SimpleQualified
    implements NamingStrategy {
        @Override
        public String name(Context ctx) {
            return ctx.method.getDeclaringClass().getSimpleName() + '.' + ctx.method.getName();
        }
    }

    public static class Default
    implements NamingStrategy {
        @Override
        public String name(Context ctx) {
            return ctx.method.getName();
        }
    }

    public static class Context {
        private final AnnotatedMethodElement method;
        private final String httpVerb;
        private final String path;

        public Context(AnnotatedMethodElement method, String httpVerb, String path) {
            this.method = method;
            this.httpVerb = httpVerb;
            this.path = path;
        }

        public AnnotatedMethodElement getMethod() {
            return this.method;
        }

        public String getHttpVerb() {
            return this.httpVerb;
        }

        public String getPath() {
            return this.path;
        }
    }
}

