/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.processor;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.annotation.JsonbProperty;
import java.beans.Introspector;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.openapi.impl.model.DiscriminatorImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.SchemaImpl;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class SchemaProcessor {
    private final Map<Type, org.eclipse.microprofile.openapi.models.media.Schema> cache = new HashMap<Type, org.eclipse.microprofile.openapi.models.media.Schema>();
    private final Map<Class<?>, String> providedRefs = new HashMap();
    private final Class<?> persistenceCapable;
    private final Class<?> responseType;
    private final JsonReaderFactory jsonReaderFactory;

    public SchemaProcessor() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> pc = null;
        try {
            pc = loader.loadClass("org.apache.openjpa.enhance.PersistenceCapable");
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        Class<?> responseType = null;
        try {
            responseType = loader.loadClass("jakarta.ws.rs.core.Response");
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        this.jsonReaderFactory = Json.createReaderFactory(Collections.emptyMap());
        this.persistenceCapable = pc;
        this.responseType = responseType;
    }

    public org.eclipse.microprofile.openapi.models.media.Schema mapSchemaFromClass(Supplier<Components> components, Type model) {
        org.eclipse.microprofile.openapi.models.media.Schema cached = this.cache.get(model);
        if (cached != null) {
            return (org.eclipse.microprofile.openapi.models.media.Schema)new SchemaImpl().type(cached.getType()).ref(this.toRef((Class)Class.class.cast(model), null));
        }
        SchemaImpl schema = new SchemaImpl();
        this.fillSchema(components, model, schema, null);
        return schema;
    }

    private String toRef(Class<?> model, String providedRef) {
        return "#/components/schemas/" + this.toRefName(model, providedRef);
    }

    private String toRefName(Class<?> model, String providedRef) {
        return this.providedRefs.computeIfAbsent(model, k -> Optional.ofNullable(providedRef).orElseGet(() -> k.getName().replace('.', '_').replace('$', '_')));
    }

    public void fillSchema(Supplier<Components> components, Type rawModel, org.eclipse.microprofile.openapi.models.media.Schema schema, String providedRef) {
        Type model = this.unwrapType(rawModel);
        if (Class.class.isInstance(model)) {
            if (Boolean.TYPE == model) {
                schema.type(Schema.SchemaType.BOOLEAN);
            } else if (Boolean.class == model) {
                schema.type(Schema.SchemaType.BOOLEAN).nullable(Boolean.valueOf(true));
            } else if (String.class == model || JsonString.class == model) {
                schema.type(Schema.SchemaType.STRING);
            } else if (Double.TYPE == model || Float.TYPE == model) {
                schema.type(Schema.SchemaType.NUMBER);
            } else if (Double.class == model || Float.class == model || JsonNumber.class == model) {
                schema.type(Schema.SchemaType.NUMBER).nullable(Boolean.valueOf(true));
            } else if (Integer.TYPE == model || Short.TYPE == model || Byte.TYPE == model || Long.TYPE == model) {
                schema.type(Schema.SchemaType.INTEGER);
            } else if (Integer.class == model || Short.class == model || Byte.class == model || Long.class == model) {
                schema.type(Schema.SchemaType.INTEGER).nullable(Boolean.valueOf(true));
            } else if (Object.class == model || this.responseType == model || JsonObject.class == model || JsonValue.class == model) {
                schema.type(Schema.SchemaType.OBJECT).nullable(Boolean.valueOf(true)).properties(new HashMap());
            } else if (BigDecimal.class == model || BigInteger.class == model) {
                schema.type(Schema.SchemaType.STRING).nullable(Boolean.valueOf(true));
            } else if (JsonArray.class == model) {
                schema.type(Schema.SchemaType.ARRAY).nullable(Boolean.valueOf(true)).items(new SchemaImpl().type(Schema.SchemaType.OBJECT).properties(new HashMap()));
            } else if (this.isStringable(model)) {
                schema.type(Schema.SchemaType.STRING).nullable(Boolean.valueOf(true));
            } else {
                Class from = (Class)Class.class.cast(model);
                if (from.isEnum()) {
                    schema.type(Schema.SchemaType.STRING).enumeration(Arrays.asList(from.getEnumConstants())).nullable(Boolean.valueOf(true));
                } else if (from.isArray()) {
                    schema.type(Schema.SchemaType.ARRAY);
                    SchemaImpl items = new SchemaImpl();
                    this.fillSchema(components, from.getComponentType(), items, null);
                    schema.items((org.eclipse.microprofile.openapi.models.media.Schema)items);
                } else if (Collection.class.isAssignableFrom(from)) {
                    schema.type(Schema.SchemaType.ARRAY);
                    SchemaImpl items = new SchemaImpl();
                    this.fillSchema(components, (Type)((Object)Object.class), items, null);
                    schema.items((org.eclipse.microprofile.openapi.models.media.Schema)items);
                } else {
                    String ref = Optional.ofNullable(from.getAnnotation(Schema.class)).filter(a -> !a.name().isEmpty()).map(s -> {
                        String sRef = s.name();
                        this.sets(components, (Schema)s, schema, sRef);
                        return sRef;
                    }).orElse(providedRef);
                    schema.type(Schema.SchemaType.OBJECT);
                    org.eclipse.microprofile.openapi.models.media.Schema objectSchema = this.getOrCreateReusableObjectComponent(components, from, ref);
                    if (schema != objectSchema) {
                        schema.ref(this.toRef(from, ref));
                    }
                }
            }
        } else {
            schema.items((org.eclipse.microprofile.openapi.models.media.Schema)new SchemaImpl());
            if (ParameterizedType.class.isInstance(model)) {
                ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(model);
                if (Class.class.isInstance(pt.getRawType()) && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType()))) {
                    schema.type(Schema.SchemaType.OBJECT);
                } else if (pt.getActualTypeArguments().length == 1 && Class.class.isInstance(pt.getActualTypeArguments()[0])) {
                    schema.type(Schema.SchemaType.ARRAY);
                    SchemaImpl items = new SchemaImpl();
                    this.fillSchema(components, (Type)Class.class.cast(pt.getActualTypeArguments()[0]), items, null);
                    schema.items((org.eclipse.microprofile.openapi.models.media.Schema)items);
                } else {
                    schema.type(Schema.SchemaType.ARRAY);
                }
            } else {
                schema.type(Schema.SchemaType.ARRAY);
            }
        }
    }

    private org.eclipse.microprofile.openapi.models.media.Schema getOrCreateReusableObjectComponent(Supplier<Components> components, Class from, String providedRef) {
        org.eclipse.microprofile.openapi.models.media.Schema existingSchema = this.cache.get(from);
        if (existingSchema != null) {
            return existingSchema;
        }
        SchemaImpl schema = new SchemaImpl();
        Optional.ofNullable(from.getAnnotation(Schema.class)).ifPresent(s -> this.sets(components, (Schema)Schema.class.cast(s), schema, null));
        schema.type(Schema.SchemaType.OBJECT);
        if (this.cache.putIfAbsent(from, schema) == null) {
            components.get().addSchema(this.toRefName(from, providedRef), (org.eclipse.microprofile.openapi.models.media.Schema)schema);
        }
        Predicate<String> ignored = this.createIgnorePredicate(from);
        schema.properties(new HashMap<String, org.eclipse.microprofile.openapi.models.media.Schema>());
        for (Class current = from; current != null && current != Object.class; current = current.getSuperclass()) {
            Stream.of(current.getDeclaredFields()).filter(it -> this.isVisible((AnnotatedElement)it, it.getModifiers())).peek(f -> this.handleRequired(schema, (AnnotatedElement)f, () -> this.findFieldName((Field)f))).forEach(f -> {
                String fieldName = this.findFieldName((Field)f);
                if (!ignored.test(fieldName)) {
                    schema.getProperties().put(fieldName, this.mapField(components, (AnnotatedElement)f, f.getGenericType()));
                }
            });
            Stream.of(current.getDeclaredMethods()).filter(it -> this.isVisible((AnnotatedElement)it, it.getModifiers())).filter(it -> (it.getName().startsWith("get") || it.getName().startsWith("is")) && it.getName().length() > 2).peek(m -> this.handleRequired(schema, (AnnotatedElement)m, () -> this.findMethodName((Method)m))).forEach(m -> {
                String key = this.findMethodName((Method)m);
                if (!ignored.test(key) && !schema.getProperties().containsKey(key)) {
                    schema.getProperties().put(key, this.mapField(components, (AnnotatedElement)m, m.getGenericReturnType()));
                }
            });
        }
        return schema;
    }

    private Predicate<String> createIgnorePredicate(Class from) {
        return this.persistenceCapable != null && this.persistenceCapable.isAssignableFrom(from) ? v -> v.startsWith("pc") : v -> false;
    }

    private boolean isVisible(AnnotatedElement elt, int modifiers) {
        boolean explicit = elt.isAnnotationPresent(Schema.class);
        if (!explicit || !elt.getAnnotation(Schema.class).hidden()) {
            return (!Modifier.isPrivate(modifiers) || elt.isAnnotationPresent(Schema.class)) && !Modifier.isStatic(modifiers);
        }
        return false;
    }

    private Type unwrapType(Type rawModel) {
        if (ParameterizedType.class.isInstance(rawModel)) {
            if (Stream.of(((ParameterizedType)ParameterizedType.class.cast(rawModel)).getActualTypeArguments()).allMatch(WildcardType.class::isInstance)) {
                return ((ParameterizedType)ParameterizedType.class.cast(rawModel)).getRawType();
            }
        }
        return rawModel;
    }

    private boolean isStringable(Type model) {
        return Date.class == model || model.getTypeName().startsWith("java.time.") || Class.class == model || Type.class == model;
    }

    private void handleRequired(org.eclipse.microprofile.openapi.models.media.Schema schema, AnnotatedElement element, Supplier<String> nameSupplier) {
        if (!element.isAnnotationPresent(Schema.class) || !element.getAnnotation(Schema.class).required()) {
            return;
        }
        if (schema.getRequired() == null) {
            schema.required(new ArrayList());
        }
        String name = nameSupplier.get();
        if (!schema.getRequired().contains(name)) {
            schema.getRequired().add(name);
        }
    }

    private org.eclipse.microprofile.openapi.models.media.Schema mapField(Supplier<Components> components, AnnotatedElement element, Type type) {
        Schema annotation = element.getAnnotation(Schema.class);
        return Optional.ofNullable(annotation).map(s -> this.mapSchema(components, (Schema)s, null)).orElseGet(() -> {
            org.eclipse.microprofile.openapi.models.media.Schema schemaFromClass = this.mapSchemaFromClass(components, type);
            if (annotation != null) {
                this.mergeSchema(components, schemaFromClass, annotation, type);
            }
            return schemaFromClass;
        });
    }

    private String findFieldName(Field f) {
        return this.findSchemaName(f).orElseGet(() -> {
            String fName;
            block7: {
                if (f.isAnnotationPresent(JsonbProperty.class)) {
                    return f.getAnnotation(JsonbProperty.class).value();
                }
                fName = f.getName();
                String subName = Character.toUpperCase(fName.charAt(0)) + (fName.length() > 1 ? fName.substring(1) : "");
                try {
                    Method getter = f.getDeclaringClass().getMethod("get" + subName, new Class[0]);
                    if (getter.isAnnotationPresent(JsonbProperty.class)) {
                        return getter.getAnnotation(JsonbProperty.class).value();
                    }
                }
                catch (NoSuchMethodException e) {
                    if (Boolean.TYPE != f.getType()) break block7;
                    try {
                        Method isser = f.getDeclaringClass().getMethod("is" + subName, new Class[0]);
                        if (isser.isAnnotationPresent(JsonbProperty.class)) {
                            return isser.getAnnotation(JsonbProperty.class).value();
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            return fName;
        });
    }

    private String findMethodName(Method m) {
        return this.findSchemaName(m).orElseGet(() -> {
            if (m.isAnnotationPresent(JsonbProperty.class)) {
                return m.getAnnotation(JsonbProperty.class).value();
            }
            String name = m.getName();
            if (name.startsWith("get")) {
                return Introspector.decapitalize(name.substring("get".length()));
            }
            if (name.startsWith("is")) {
                return Introspector.decapitalize(name.substring("is".length()));
            }
            return Introspector.decapitalize(name);
        });
    }

    private Optional<String> findSchemaName(AnnotatedElement m) {
        return Optional.ofNullable(m.getAnnotation(Schema.class)).map(Schema::name).filter(it -> !it.isEmpty());
    }

    private void mergeSchema(Supplier<Components> components, org.eclipse.microprofile.openapi.models.media.Schema impl, Schema schema, Type type) {
        List enums;
        List allOf;
        List anyOf;
        String example;
        if (schema.deprecated()) {
            impl.deprecated(Boolean.valueOf(schema.deprecated()));
        }
        if (schema.type() != SchemaType.DEFAULT) {
            impl.type(Schema.SchemaType.valueOf((String)schema.type().name()));
        }
        if (!schema.title().isEmpty()) {
            impl.title(schema.title());
        }
        if (!schema.description().isEmpty()) {
            impl.description(schema.description());
        }
        if (!schema.format().isEmpty()) {
            impl.format(schema.format());
        }
        if (!schema.ref().isEmpty()) {
            impl.ref(schema.ref());
        }
        if (!(example = schema.example()).isEmpty()) {
            if (type != null) {
                if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
                    impl.example((Object)Double.parseDouble(example));
                } else if (type == Long.TYPE || type == Long.class || type == Integer.TYPE || type == Integer.class || type == Short.TYPE || type == Short.class || type == Byte.TYPE || type == Byte.class) {
                    impl.example((Object)Integer.parseInt(example));
                } else if (type == Boolean.TYPE || type == Boolean.class) {
                    impl.example((Object)Boolean.parseBoolean(example));
                } else if (type == String.class) {
                    impl.example((Object)example);
                } else if (example.startsWith("{") && example.endsWith("}") || example.startsWith("[") && example.endsWith("}")) {
                    try (JsonReader reader = this.jsonReaderFactory.createReader((Reader)new StringReader(example));){
                        impl.example((Object)reader.readValue());
                    }
                    catch (Exception e) {
                        impl.example((Object)example);
                    }
                } else {
                    impl.example((Object)example);
                }
            } else {
                impl.example((Object)example);
            }
        }
        Optional.of(schema.not()).filter(it -> it != Void.class).ifPresent(t -> impl.not(this.mapSchemaFromClass(components, (Type)t)));
        List oneOf = Stream.of(schema.oneOf()).map(it -> this.mapSchemaFromClass(components, (Type)it)).collect(Collectors.toList());
        if (!oneOf.isEmpty()) {
            impl.oneOf(oneOf);
        }
        if (!(anyOf = Stream.of(schema.anyOf()).map(it -> this.mapSchemaFromClass(components, (Type)it)).collect(Collectors.toList())).isEmpty()) {
            impl.anyOf(anyOf);
        }
        if (!(allOf = Stream.of(schema.allOf()).map(it -> this.mapSchemaFromClass(components, (Type)it)).collect(Collectors.toList())).isEmpty()) {
            impl.allOf(allOf);
        }
        if (schema.multipleOf() != 0.0) {
            impl.multipleOf(BigDecimal.valueOf(schema.multipleOf()));
        }
        impl.minimum(this.toBigDecimal(schema.minimum()));
        impl.maximum(this.toBigDecimal(schema.maximum()));
        if (schema.exclusiveMinimum()) {
            impl.exclusiveMinimum(Boolean.valueOf(schema.exclusiveMinimum()));
        }
        if (schema.exclusiveMaximum()) {
            impl.exclusiveMaximum(Boolean.valueOf(schema.exclusiveMaximum()));
        }
        if (schema.minLength() >= 0 && schema.minLength() != 0) {
            impl.minLength(Integer.valueOf(schema.minLength()));
        }
        if (schema.maxLength() >= 0 && schema.maxLength() != Integer.MAX_VALUE) {
            impl.maxLength(Integer.valueOf(schema.maxLength()));
        }
        if (!schema.pattern().isEmpty()) {
            impl.pattern(schema.pattern());
        }
        if (schema.nullable()) {
            impl.nullable(Boolean.valueOf(schema.nullable()));
        }
        if (schema.minProperties() > 0) {
            impl.minProperties(Integer.valueOf(schema.minProperties()));
        }
        if (schema.minProperties() > 0) {
            impl.maxProperties(Integer.valueOf(schema.maxProperties()));
        }
        if (schema.minItems() < Integer.MAX_VALUE) {
            impl.minItems(Integer.valueOf(schema.minItems()));
        }
        if (schema.maxItems() > Integer.MIN_VALUE) {
            impl.maxItems(Integer.valueOf(schema.maxItems()));
        }
        if (schema.uniqueItems()) {
            impl.uniqueItems(Boolean.valueOf(schema.uniqueItems()));
        }
        if (schema.readOnly()) {
            impl.readOnly(Boolean.valueOf(schema.readOnly()));
        }
        if (schema.writeOnly()) {
            impl.writeOnly(Boolean.valueOf(schema.writeOnly()));
        }
        impl.defaultValue(this.toType(schema.defaultValue(), impl.getType()));
        List required = Stream.of(schema.requiredProperties()).collect(Collectors.toList());
        if (!required.isEmpty()) {
            impl.required(required);
        }
        if (schema.discriminatorMapping().length > 0) {
            impl.discriminator(new DiscriminatorImpl().mapping(Stream.of(schema.discriminatorMapping()).collect(Collectors.toMap(DiscriminatorMapping::value, it -> it.schema().getName()))));
        }
        if (!(enums = Stream.of(schema.enumeration()).collect(Collectors.toList())).isEmpty()) {
            impl.setEnumeration(enums);
        }
    }

    public org.eclipse.microprofile.openapi.models.media.Schema mapSchema(Supplier<Components> components, Schema schema, String providedRefMapping) {
        if (schema.hidden() || schema.implementation() == Void.class && schema.name().isEmpty() && schema.ref().isEmpty()) {
            if (schema.type() != SchemaType.DEFAULT) {
                return new SchemaImpl().type(Schema.SchemaType.valueOf((String)schema.type().name()));
            }
            return null;
        }
        SchemaImpl impl = new SchemaImpl();
        this.sets(components, schema, impl, providedRefMapping);
        return impl;
    }

    private void sets(Supplier<Components> components, Schema schema, org.eclipse.microprofile.openapi.models.media.Schema impl, String providedRef) {
        if (!schema.ref().isEmpty()) {
            impl.ref(this.resolveSchemaRef(schema.ref()));
        } else {
            if (schema.implementation() != Void.class) {
                boolean array;
                boolean bl = array = schema.type() == SchemaType.ARRAY;
                if (array) {
                    SchemaImpl itemSchema = new SchemaImpl();
                    this.fillSchema(components, schema.implementation(), itemSchema, providedRef);
                    impl.items((org.eclipse.microprofile.openapi.models.media.Schema)itemSchema);
                } else {
                    this.fillSchema(components, schema.implementation(), impl, providedRef);
                }
            }
            this.mergeSchema(components, impl, schema, null);
        }
    }

    private String resolveSchemaRef(String ref) {
        if (ref.startsWith("#")) {
            return ref;
        }
        return "#/components/schemas/" + ref;
    }

    private BigDecimal toBigDecimal(String minimum) {
        return minimum.isEmpty() ? null : new BigDecimal(minimum);
    }

    private Object toType(String s, Schema.SchemaType type) {
        if (type == null || s.isEmpty()) {
            return null;
        }
        switch (type) {
            case STRING: {
                return s;
            }
            case INTEGER: {
                return Integer.valueOf(s);
            }
            case NUMBER: {
                return Double.valueOf(s);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(s);
            }
        }
        return null;
    }
}

