/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import org.apache.geronimo.microprofile.metrics.cdi.Names;
import org.apache.geronimo.microprofile.metrics.common.BaseMetrics;
import org.apache.geronimo.microprofile.metrics.common.GaugeImpl;
import org.apache.geronimo.microprofile.metrics.common.RegistryImpl;
import org.apache.geronimo.microprofile.metrics.jaxrs.CdiMetricsEndpoints;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsExtension
implements Extension {
    private final MetricRegistry applicationRegistry = new RegistryImpl();
    private final MetricRegistry baseRegistry = new RegistryImpl();
    private final MetricRegistry vendorRegistry = new RegistryImpl();
    private final Map<String, Metadata> registrations = new HashMap<String, Metadata>();
    private final Map<String, Function<BeanManager, Gauge<?>>> gaugeFactories = new HashMap();
    private final Collection<Runnable> producersRegistrations = new ArrayList<Runnable>();
    private final Collection<CreationalContext<?>> creationalContexts = new ArrayList();

    void letOtherExtensionsUseRegistries(@Observes ProcessAnnotatedType<CdiMetricsEndpoints> processAnnotatedType) {
        if ("false".equalsIgnoreCase(System.getProperty("geronimo.metrics.jaxrs.activated"))) {
            processAnnotatedType.veto();
        }
    }

    void letOtherExtensionsUseRegistries(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addQualifier(RegistryType.class);
        beanManager.fireEvent((Object)this.applicationRegistry, new Annotation[0]);
        beanManager.fireEvent((Object)this.applicationRegistry, new Annotation[]{new RegistryTypeImpl(MetricRegistry.Type.APPLICATION)});
        beanManager.fireEvent((Object)this.baseRegistry, new Annotation[]{new RegistryTypeImpl(MetricRegistry.Type.BASE)});
        beanManager.fireEvent((Object)this.vendorRegistry, new Annotation[]{new RegistryTypeImpl(MetricRegistry.Type.VENDOR)});
        beforeBeanDiscovery.configureQualifier(Metric.class).methods().stream().filter(method -> method.getAnnotated().getJavaMember().getName().equals("name")).forEach(method -> method.remove(a -> a.annotationType() == Nonbinding.class));
    }

    private void onMetric(@Observes ProcessProducerField<? extends org.eclipse.microprofile.metrics.Metric, ?> processProducerField, BeanManager beanManager) {
        Metric config = (Metric)processProducerField.getAnnotated().getAnnotation(Metric.class);
        if (config == null) {
            return;
        }
        Class<?> clazz = this.findClass(processProducerField.getAnnotated().getBaseType());
        if (clazz == null || !org.eclipse.microprofile.metrics.Metric.class.isAssignableFrom(clazz)) {
            return;
        }
        Field javaMember = processProducerField.getAnnotatedProducerField().getJavaMember();
        Bean bean = processProducerField.getBean();
        this.producersRegistrations.add(() -> this.registerProducer(beanManager, config, clazz, javaMember, bean));
    }

    private void onMetric(@Observes ProcessProducerMethod<? extends org.eclipse.microprofile.metrics.Metric, ?> processProducerMethod, BeanManager beanManager) {
        Metric config = (Metric)processProducerMethod.getAnnotated().getAnnotation(Metric.class);
        if (config == null) {
            return;
        }
        Class<?> clazz = this.findClass(processProducerMethod.getAnnotated().getBaseType());
        if (clazz == null || !org.eclipse.microprofile.metrics.Metric.class.isAssignableFrom(clazz)) {
            return;
        }
        Method javaMember = processProducerMethod.getAnnotatedProducerMethod().getJavaMember();
        Bean bean = processProducerMethod.getBean();
        this.producersRegistrations.add(() -> this.registerProducer(beanManager, config, clazz, javaMember, bean));
    }

    void onMetric(@Observes ProcessInjectionPoint<?, ?> metricInjectionPointProcessEvent) {
        InjectionPoint injectionPoint = metricInjectionPointProcessEvent.getInjectionPoint();
        Class<?> clazz = this.findClass(injectionPoint.getType());
        if (clazz == null || !org.eclipse.microprofile.metrics.Metric.class.isAssignableFrom(clazz)) {
            return;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        Metric config = (Metric)annotated.getAnnotation(Metric.class);
        MetricType type = this.findType(clazz);
        if (config != null) {
            String name = Names.findName(injectionPoint.getMember().getDeclaringClass(), injectionPoint.getMember(), Optional.of(config.name()).filter(it -> !it.isEmpty()).orElseGet(injectionPoint.getMember()::getName), config.absolute(), "");
            Metadata metadata = new Metadata(name, config.displayName(), config.description(), type, config.unit());
            Stream.of(config.tags()).forEach(arg_0 -> ((Metadata)metadata).addTag(arg_0));
            Metadata existing = this.registrations.putIfAbsent(name, metadata);
            if (existing != null) {
                Stream.of(config.tags()).forEach(arg_0 -> ((Metadata)existing).addTag(arg_0));
            }
            if (!name.equals(config.name())) {
                Annotation[] newQualifiers = (Annotation[])Stream.concat(metricInjectionPointProcessEvent.getInjectionPoint().getQualifiers().stream().filter(it -> it.annotationType() != Metric.class), Stream.of(new MetricImpl(metadata))).toArray(Annotation[]::new);
                metricInjectionPointProcessEvent.configureInjectionPoint().qualifiers(newQualifiers);
            }
        } else {
            String name = MetricRegistry.name(injectionPoint.getMember().getDeclaringClass(), (String[])new String[]{injectionPoint.getMember().getName()});
            Metadata metadata = new Metadata(name, type);
            this.registrations.putIfAbsent(name, metadata);
            Annotation[] newQualifiers = (Annotation[])Stream.concat(metricInjectionPointProcessEvent.getInjectionPoint().getQualifiers().stream().filter(it -> it.annotationType() != Default.class), Stream.of(new MetricImpl(metadata))).toArray(Annotation[]::new);
            metricInjectionPointProcessEvent.configureInjectionPoint().qualifiers(newQualifiers);
        }
    }

    void findInterceptorMetrics(@Observes @WithAnnotations(value={Counted.class, Timed.class, Metered.class, org.eclipse.microprofile.metrics.annotation.Gauge.class}) ProcessAnnotatedType<?> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        if (javaClass.getName().startsWith("org.apache.geronimo.microprofile.metrics.") || Modifier.isAbstract(javaClass.getModifiers()) || javaClass.isInterface()) {
            return;
        }
        Stream.concat(annotatedType.getMethods().stream(), annotatedType.getConstructors().stream()).filter(method -> method.getJavaMember().getDeclaringClass() == javaClass || Modifier.isAbstract(method.getJavaMember().getDeclaringClass().getModifiers())).filter(method -> !method.getJavaMember().isSynthetic() && !Modifier.isPrivate(method.getJavaMember().getModifiers())).forEach(method -> {
            org.eclipse.microprofile.metrics.annotation.Gauge gauge;
            Metadata metadata;
            String name;
            Metered metered;
            Timed timed;
            Member javaMember = method.getJavaMember();
            Counted counted = Optional.ofNullable(method.getAnnotation(Counted.class)).orElseGet(() -> (Counted)annotatedType.getAnnotation(Counted.class));
            if (counted != null) {
                boolean isMethod = method.isAnnotationPresent(Counted.class);
                String name2 = Names.findName(javaClass, javaMember, isMethod ? counted.name() : "", counted.absolute(), Optional.ofNullable(annotatedType.getAnnotation(Counted.class)).map(Counted::name).orElse(""));
                Metadata metadata2 = new Metadata(name2, counted.displayName(), counted.description(), MetricType.COUNTER, counted.unit());
                Stream.of(counted.tags()).forEach(arg_0 -> ((Metadata)metadata2).addTag(arg_0));
                this.addRegistration((AnnotatedCallable<?>)method, name2, metadata2, counted.reusable() || !isMethod, counted.tags());
            }
            if ((timed = Optional.ofNullable(method.getAnnotation(Timed.class)).orElseGet(() -> (Timed)annotatedType.getAnnotation(Timed.class))) != null) {
                boolean isMethod = method.isAnnotationPresent(Timed.class);
                String name3 = Names.findName(javaClass, javaMember, isMethod ? timed.name() : "", timed.absolute(), Optional.ofNullable(annotatedType.getAnnotation(Timed.class)).map(Timed::name).orElse(""));
                Metadata metadata3 = new Metadata(name3, timed.displayName(), timed.description(), MetricType.TIMER, timed.unit());
                Stream.of(timed.tags()).forEach(arg_0 -> ((Metadata)metadata3).addTag(arg_0));
                this.addRegistration((AnnotatedCallable<?>)method, name3, metadata3, timed.reusable() || !isMethod, timed.tags());
            }
            if ((metered = Optional.ofNullable(method.getAnnotation(Metered.class)).orElseGet(() -> (Metered)annotatedType.getAnnotation(Metered.class))) != null) {
                boolean isMethod = method.isAnnotationPresent(Metered.class);
                name = Names.findName(javaClass, javaMember, isMethod ? metered.name() : "", metered.absolute(), Optional.ofNullable(annotatedType.getAnnotation(Metered.class)).map(Metered::name).orElse(""));
                metadata = new Metadata(name, metered.displayName(), metered.description(), MetricType.METERED, metered.unit());
                Stream.of(metered.tags()).forEach(arg_0 -> ((Metadata)metadata).addTag(arg_0));
                this.addRegistration((AnnotatedCallable<?>)method, name, metadata, metered.reusable() || !isMethod, metered.tags());
            }
            if ((gauge = Optional.ofNullable(method.getAnnotation(org.eclipse.microprofile.metrics.annotation.Gauge.class)).orElseGet(() -> (org.eclipse.microprofile.metrics.annotation.Gauge)annotatedType.getAnnotation(org.eclipse.microprofile.metrics.annotation.Gauge.class))) != null) {
                name = Names.findName(javaClass, javaMember, gauge.name(), gauge.absolute(), Optional.ofNullable(annotatedType.getAnnotation(org.eclipse.microprofile.metrics.annotation.Gauge.class)).map(org.eclipse.microprofile.metrics.annotation.Gauge::name).orElse(""));
                metadata = new Metadata(name, gauge.displayName(), gauge.description(), MetricType.GAUGE, gauge.unit());
                Stream.of(gauge.tags()).forEach(arg_0 -> ((Metadata)metadata).addTag(arg_0));
                this.addRegistration((AnnotatedCallable<?>)method, name, metadata, false, gauge.tags());
                this.gaugeFactories.put(name, beanManager -> {
                    Object reference = this.getInstance(javaClass, (BeanManager)beanManager);
                    Method mtd = (Method)Method.class.cast(javaMember);
                    return new GaugeImpl(reference, mtd);
                });
            }
        });
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        this.addBean(afterBeanDiscovery, MetricRegistry.Type.APPLICATION.name() + "_@Default", MetricRegistry.class, (Annotation)Default.Literal.INSTANCE, this.applicationRegistry);
        this.addBean(afterBeanDiscovery, MetricRegistry.Type.APPLICATION.name(), MetricRegistry.class, (Annotation)((Object)new RegistryTypeImpl(MetricRegistry.Type.APPLICATION)), this.applicationRegistry);
        this.addBean(afterBeanDiscovery, MetricRegistry.Type.BASE.name(), MetricRegistry.class, (Annotation)((Object)new RegistryTypeImpl(MetricRegistry.Type.BASE)), this.baseRegistry);
        this.addBean(afterBeanDiscovery, MetricRegistry.Type.VENDOR.name(), MetricRegistry.class, (Annotation)((Object)new RegistryTypeImpl(MetricRegistry.Type.VENDOR)), this.vendorRegistry);
        this.registrations.forEach((name, registration) -> {
            switch (registration.getTypeRaw()) {
                case GAUGE: {
                    this.addBean(afterBeanDiscovery, (String)name, Gauge.class, (Annotation)((Object)new MetricImpl((Metadata)registration)), new Gauge<Object>(){
                        private final AtomicReference ref = new AtomicReference();

                        public Object getValue() {
                            Gauge gauge = (Gauge)this.ref.get();
                            if (gauge == null) {
                                gauge = (Gauge)MetricsExtension.this.applicationRegistry.getGauges().get(name);
                                this.ref.compareAndSet(null, gauge);
                            }
                            return gauge.getValue();
                        }
                    });
                    break;
                }
                case TIMER: {
                    this.addBean(afterBeanDiscovery, (String)name, Timer.class, (Annotation)((Object)new MetricImpl((Metadata)registration)), this.applicationRegistry.timer(registration));
                    break;
                }
                case COUNTER: {
                    this.addBean(afterBeanDiscovery, (String)name, Counter.class, (Annotation)((Object)new MetricImpl((Metadata)registration)), this.applicationRegistry.counter(registration));
                    break;
                }
                case METERED: {
                    this.addBean(afterBeanDiscovery, (String)name, Meter.class, (Annotation)((Object)new MetricImpl((Metadata)registration)), this.applicationRegistry.meter(registration));
                    break;
                }
                case HISTOGRAM: {
                    this.addBean(afterBeanDiscovery, (String)name, Histogram.class, (Annotation)((Object)new MetricImpl((Metadata)registration)), this.applicationRegistry.histogram(registration));
                    break;
                }
            }
        });
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        this.registrations.values().stream().filter(m -> m.getTypeRaw() == MetricType.GAUGE).forEach(registration -> {
            Gauge<?> gauge = this.gaugeFactories.get(registration.getName()).apply(beanManager);
            this.applicationRegistry.register(registration, gauge);
        });
        this.producersRegistrations.forEach(Runnable::run);
        this.producersRegistrations.clear();
        this.gaugeFactories.clear();
        this.registrations.clear();
        this.vendorRegistry.counter("startTime").inc(System.currentTimeMillis());
        if (!Boolean.getBoolean("geronimo.metrics.base.skip")) {
            new BaseMetrics(this.baseRegistry).register();
        }
    }

    void beforeShutdown(@Observes BeforeShutdown beforeShutdown) {
        this.creationalContexts.forEach(CreationalContext::release);
    }

    private void registerProducer(BeanManager beanManager, Metric config, Class<?> clazz, Member javaMember, Bean<?> bean) {
        Class<?> beanClass = bean.getBeanClass();
        if (beanClass == null) {
            beanClass = javaMember.getDeclaringClass();
        }
        Metadata metadata = this.createMetadata(config, clazz, javaMember, beanClass);
        this.applicationRegistry.register(metadata, (org.eclipse.microprofile.metrics.Metric)org.eclipse.microprofile.metrics.Metric.class.cast(this.getInstance(clazz, beanManager, bean)));
    }

    private Metadata createMetadata(Metric config, Class<?> clazz, Member javaMember, Class<?> beanClass) {
        String name = Names.findName(beanClass, javaMember, Optional.of(config.name()).filter(it -> !it.isEmpty()).orElseGet(javaMember::getName), config.absolute(), "");
        Metadata metadata = new Metadata(name, config.displayName(), config.description(), this.findType(clazz), config.unit());
        Stream.of(config.tags()).forEach(arg_0 -> ((Metadata)metadata).addTag(arg_0));
        Metadata existing = this.registrations.putIfAbsent(name, metadata);
        if (existing != null) {
            Stream.of(config.tags()).forEach(arg_0 -> ((Metadata)existing).addTag(arg_0));
        }
        return metadata;
    }

    private MetricType findType(Class<?> clazz) {
        MetricType type = Counter.class.isAssignableFrom(clazz) ? MetricType.COUNTER : (Gauge.class.isAssignableFrom(clazz) ? MetricType.GAUGE : (Meter.class.isAssignableFrom(clazz) ? MetricType.METERED : (Timer.class.isAssignableFrom(clazz) ? MetricType.TIMER : (Histogram.class.isAssignableFrom(clazz) ? MetricType.HISTOGRAM : MetricType.INVALID))));
        return type;
    }

    private Class<?> findClass(Type baseType) {
        Type type = baseType;
        if (ParameterizedType.class.isInstance(baseType)) {
            type = ((ParameterizedType)ParameterizedType.class.cast(baseType)).getRawType();
        }
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        return null;
    }

    private Object getInstance(Class<?> javaClass, BeanManager beanManager) {
        Bean bean = beanManager.resolve(beanManager.getBeans(javaClass, new Annotation[]{Default.Literal.INSTANCE}));
        return this.getInstance(javaClass, beanManager, bean);
    }

    private Object getInstance(Class<?> javaClass, BeanManager beanManager, Bean<?> bean) {
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        Object reference = beanManager.getReference(bean, javaClass, creationalContext);
        if (!beanManager.isNormalScope(bean.getScope())) {
            this.creationalContexts.add(creationalContext);
        }
        return reference;
    }

    private void addRegistration(AnnotatedCallable<?> executable, String name, Metadata metadata, boolean reusable, String[] tags) {
        Metadata existing = this.registrations.putIfAbsent(name, metadata);
        if (existing != null) {
            if (reusable) {
                Stream.of(tags).forEach(arg_0 -> ((Metadata)metadata).addTag(arg_0));
            } else {
                throw new IllegalArgumentException(name + " is not set as reusable on " + executable + " but was used somewhere else");
            }
        }
    }

    private void addBean(AfterBeanDiscovery afterBeanDiscovery, String idSuffix, Class<?> type, Annotation qualifier, Object instance) {
        afterBeanDiscovery.addBean().id(MetricsExtension.class.getName() + ":" + type.getName() + ":" + idSuffix).beanClass(type).types(new Type[]{type, Object.class}).qualifiers(new Annotation[]{qualifier, Any.Literal.INSTANCE}).scope(Dependent.class).createWith(c -> instance);
    }

    private static final class RegistryTypeImpl
    extends AnnotationLiteral<RegistryType>
    implements RegistryType {
        private final MetricRegistry.Type type;

        private RegistryTypeImpl(MetricRegistry.Type type) {
            this.type = type;
        }

        public MetricRegistry.Type type() {
            return this.type;
        }

        public Class<? extends Annotation> annotationType() {
            return RegistryType.class;
        }
    }

    private static final class MetricImpl
    extends AnnotationLiteral<Metric>
    implements Metric {
        private final Metadata metadata;
        private final String[] tags;

        private MetricImpl(Metadata metadata) {
            this.metadata = metadata;
            this.tags = metadata.getTagsAsString().split(",");
        }

        public Class<? extends Annotation> annotationType() {
            return Metric.class;
        }

        public String name() {
            return this.metadata.getName();
        }

        public String[] tags() {
            return this.tags;
        }

        public boolean absolute() {
            return false;
        }

        public String displayName() {
            return Optional.ofNullable(this.metadata.getDisplayName()).orElse("");
        }

        public String description() {
            return Optional.ofNullable(this.metadata.getDescription()).orElse("");
        }

        public String unit() {
            return this.metadata.getUnit();
        }
    }
}

