/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.extension.sigar;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.metrics.extension.common.Definition;
import org.apache.geronimo.microprofile.metrics.extension.common.ThrowingSupplier;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;

public class SigarRegistrar {
    private final Consumer<Definition> onRegister;
    private final Consumer<Definition> onUnregister;
    private Sigar sigarImpl;
    private SigarProxy sigar;
    private Thread refreshThread;
    private volatile boolean stopped = true;
    private long refreshInterval;
    private final Map<String, Definition> currentDefinitions = new HashMap<String, Definition>();

    public SigarRegistrar(Consumer<Definition> onRegister, Consumer<Definition> onUnregister) {
        this.onRegister = onRegister;
        this.onUnregister = onUnregister;
    }

    public synchronized void start() {
        this.sigarImpl = new Sigar();
        this.sigar = SigarProxyCache.newInstance((Sigar)this.sigarImpl, (int)Integer.getInteger("geronimo.metrics.sigar.cache", 30000));
        this.refreshInterval = Long.getLong("geronimo.metrics.sigar.refreshInterval", TimeUnit.MINUTES.toMillis(5L));
        if (this.refreshInterval > 0L) {
            this.refreshThread = new Thread(() -> {
                long iterationDuration = 250L;
                long iterations = this.refreshInterval / 250L;
                while (!this.stopped) {
                    for (long i = 0L; i < iterations; ++i) {
                        if (this.stopped) {
                            return;
                        }
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.tick();
                }
            }, this.getClass().getName() + "-refresher-" + this.hashCode());
            this.stopped = false;
            this.refreshThread.start();
        }
        this.tick();
    }

    public synchronized void tick() {
        Collection<Definition> currentMetrics = this.collectMetrics();
        Collection alreadyRegistered = currentMetrics.stream().filter(it -> this.currentDefinitions.containsKey(it.getName())).collect(Collectors.toList());
        HashSet<Definition> missingRegistered = new HashSet<Definition>(this.currentDefinitions.values());
        missingRegistered.removeAll(alreadyRegistered);
        missingRegistered.forEach(it -> {
            this.currentDefinitions.remove(it.getName());
            if (this.onUnregister != null) {
                this.onUnregister.accept((Definition)it);
            }
        });
        currentMetrics.removeAll(alreadyRegistered);
        currentMetrics.forEach(it -> this.onRegister.accept(new Definition(it.getName(), it.getDisplayName(), it.getDescription(), it.getUnit(), () -> it.getEvaluator().getAsDouble())));
    }

    public synchronized void stop() {
        if (this.refreshThread != null) {
            this.stopped = true;
            try {
                this.refreshThread.join(500L);
                if (this.refreshThread.isAlive()) {
                    this.refreshThread.interrupt();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.refreshThread = null;
            }
        }
        this.sigarImpl.close();
    }

    private Collection<Definition> collectMetrics() {
        HashSet<Definition> definitions = new HashSet<Definition>();
        this.addCpu(definitions, "sigar.cpu.", (ThrowingSupplier<Cpu>)((ThrowingSupplier)() -> this.sigar.getCpu()));
        this.addMem(definitions);
        try {
            CpuInfo[] cpuInfoList = this.sigar.getCpuInfoList();
            IntStream.range(0, cpuInfoList.length).forEach(idx -> this.addCpu(definitions, "sigar.cpu." + idx + ".", (ThrowingSupplier<Cpu>)((ThrowingSupplier)() -> this.sigar.getCpuList()[idx])));
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        this.addNetwork(definitions);
        this.addFileSystem(definitions);
        return definitions;
    }

    private void addFileSystem(Collection<Definition> definitions) {
        try {
            Stream.of(this.sigar.getFileSystemList()).filter(it -> !it.getDirName().startsWith("/sys") && !it.getDirName().startsWith("/dev") && !it.getDirName().startsWith("/proc") && !it.getDirName().startsWith("/run") && !it.getDirName().startsWith("/snap")).map(FileSystem::getDevName).distinct().forEach(devName -> {
                String baseName = "sigar.net.disk." + devName.replace('/', '_').replaceFirst("^_", "") + ".";
                definitions.add(new Definition(baseName + "read.count", devName + " Reads", "Reads on " + devName, "count", () -> this.sigar.getDiskUsage(devName).getReads()));
                definitions.add(new Definition(baseName + "write.count", devName + " Writes", "Writes on " + devName, "count", () -> this.sigar.getDiskUsage(devName).getWrites()));
                definitions.add(new Definition(baseName + "read.bytes", devName + " Reads", "Reads on " + devName, "bytes", () -> this.sigar.getDiskUsage(devName).getReadBytes()));
                definitions.add(new Definition(baseName + "write.bytes", devName + " Writes", "Writes on " + devName, "bytes", () -> this.sigar.getDiskUsage(devName).getWriteBytes()));
            });
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
    }

    private void addNetwork(Collection<Definition> definitions) {
        try {
            this.sigar.getTcp();
            definitions.add(new Definition("sigar.network.tcp.active.opens", "Opening connections", "Active connections openings", "count", () -> this.sigar.getTcp().getActiveOpens()));
            definitions.add(new Definition("sigar.network.tcp.passive.opens", "Passive connections", "Passive connection openings", "count", () -> this.sigar.getTcp().getPassiveOpens()));
            definitions.add(new Definition("sigar.network.tcp.attempts.fails", "Failed connections", "Failed connection attempts", "count", () -> this.sigar.getTcp().getAttemptFails()));
            definitions.add(new Definition("sigar.network.tcp.established.reset", "Resetted connections", "Connection resets received", "count", () -> this.sigar.getTcp().getEstabResets()));
            definitions.add(new Definition("sigar.network.tcp.established.current", "Established connections", "Connections established", "count", () -> this.sigar.getTcp().getCurrEstab()));
            definitions.add(new Definition("sigar.network.tcp.segments.in", "Received segments", "Received segments", "count", () -> this.sigar.getTcp().getInSegs()));
            definitions.add(new Definition("sigar.network.tcp.segments.out", "Sent segments", "Send out segments", "count", () -> this.sigar.getTcp().getOutSegs()));
            definitions.add(new Definition("sigar.network.tcp.segments.retrans", "Retransmitted segments", "Retransmitted segments", "count", () -> this.sigar.getTcp().getRetransSegs()));
            definitions.add(new Definition("sigar.network.tcp.resets.out", "Sent resets", "Sent resets", "count", () -> this.sigar.getTcp().getOutRsts()));
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            this.sigar.getNetStat();
            definitions.add(new Definition("sigar.network.tcp.output.total", "Total Outbound", "Sent bytes", "bytes", () -> this.sigar.getNetStat().getTcpOutboundTotal()));
            definitions.add(new Definition("sigar.network.tcp.inbound.total", "Total Inbound", "Received bytes", "bytes", () -> this.sigar.getNetStat().getTcpInboundTotal()));
            definitions.add(new Definition("sigar.network.tcp.established", "TCP established", "TCP established", "count", () -> this.sigar.getNetStat().getTcpEstablished()));
            definitions.add(new Definition("sigar.network.tcp.idle", "TCP Idle", "TCP Idle", "count", () -> this.sigar.getNetStat().getTcpIdle()));
            definitions.add(new Definition("sigar.network.tcp.closing", "TCP Closing", "TCP Closing", "count", () -> this.sigar.getNetStat().getTcpClosing()));
            definitions.add(new Definition("sigar.network.tcp.bound", "TCP Bound", "TCP Bound", "count", () -> this.sigar.getNetStat().getTcpBound()));
            definitions.add(new Definition("sigar.network.tcp.close", "TCP Close", "TCP Close", "count", () -> this.sigar.getNetStat().getTcpClose()));
            definitions.add(new Definition("sigar.network.tcp.closewait", "TCP Close Wait", "TCP Close Wait", "count", () -> this.sigar.getNetStat().getTcpCloseWait()));
            definitions.add(new Definition("sigar.network.tcp.listen", "TCP Listen", "TCP Listen", "count", () -> this.sigar.getNetStat().getTcpListen()));
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    private void addMem(Collection<Definition> definitions) {
        definitions.add(new Definition("sigar.mem.ram", "System RAM Memory", "The total amount of physical memory, in [bytes]", "bytes", () -> this.sigar.getMem().getRam()));
        definitions.add(new Definition("sigar.mem.total", "System Total Memory", "The amount of physical memory, in [bytes]", "bytes", () -> this.sigar.getMem().getTotal()));
        definitions.add(new Definition("sigar.mem.used", "System Used Memory", "The amount of physical memory in use, in [bytes]", "bytes", () -> this.sigar.getMem().getUsed()));
        definitions.add(new Definition("sigar.mem.free", "System Free Memory", "The amount of free physical memory, in [bytes]", "bytes", () -> this.sigar.getMem().getFree()));
        definitions.add(new Definition("sigar.mem.actual.used", "System Actual Used Memory", "The actual amount of physical memory in use, in [bytes]", "bytes", () -> this.sigar.getMem().getActualUsed()));
        definitions.add(new Definition("sigar.mem.actual.free", "System Actual Free Memory", "The actual amount of free physical memory, in [bytes]", "bytes", () -> this.sigar.getMem().getActualFree()));
    }

    private void addCpu(Collection<Definition> definitions, String base, ThrowingSupplier<Cpu> provider) {
        definitions.add(new Definition(base + "idle", "CPU Idle Time", "The idle time of the CPU, in [ms]", "ms", () -> ((Cpu)provider.get()).getIdle()));
        definitions.add(new Definition(base + "nice", "CPU Nice Priority Time", "The time of the CPU spent on nice priority, in [ms]", "ms", () -> ((Cpu)provider.get()).getNice()));
        definitions.add(new Definition(base + "sys", "CPU User Time", "The time of the CPU used by the system, in [ms]", "ms", () -> ((Cpu)provider.get()).getSys()));
        definitions.add(new Definition(base + "total", "CPU Total Time", "The total time of the CPU, in [ms]", "ms", () -> ((Cpu)provider.get()).getTotal()));
        definitions.add(new Definition(base + "wait", "CPU Wait Time", "The time the CPU had to wait for data to be loaded, in [ms]", "ms", () -> ((Cpu)provider.get()).getWait()));
    }
}

