/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.extension.sigar;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import org.apache.geronimo.microprofile.metrics.extension.common.MicroprofileMetricsAdapter;
import org.apache.geronimo.microprofile.metrics.extension.common.RegistryTypeLiteral;
import org.apache.geronimo.microprofile.metrics.extension.sigar.InitSigar;
import org.apache.geronimo.microprofile.metrics.extension.sigar.SigarRegistrar;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class MicroprofileMetricsSigarRegistrar
implements Extension {
    private SigarRegistrar registrar;

    void afterValidation(@Observes AfterDeploymentValidation validation, BeanManager beanManager) {
        InitSigar initSigar = new InitSigar(this.findTempDir());
        initSigar.ensureSigarIsSetup();
        if (!initSigar.isValid()) {
            return;
        }
        MetricRegistry.Type registryType = MetricRegistry.Type.valueOf((String)System.getProperty("geronimo.metrics.sigar.registry.type", "BASE"));
        Set beans = beanManager.getBeans(MetricRegistry.class, new Annotation[]{new RegistryTypeLiteral(registryType)});
        MetricRegistry registry = (MetricRegistry)MetricRegistry.class.cast(beanManager.getReference(beanManager.resolve(beans), MetricRegistry.class, beanManager.createCreationalContext(null)));
        MicroprofileMetricsAdapter adapter = new MicroprofileMetricsAdapter(registry);
        this.registrar = new SigarRegistrar(adapter.registrer(), adapter.unregistrer());
        this.registrar.start();
    }

    void beforeShutdown(@Observes BeforeShutdown beforeShutdown) {
        if (this.registrar != null) {
            this.registrar.stop();
        }
    }

    private File findTempDir() {
        return new File(Stream.of("geronimo.metrics.sigar.location", "catalina.base", "catalina.base", "meecrowave.base", "tomee.base", "application.base", "application.home").map(System::getProperty).filter(Objects::nonNull).map(File::new).filter(File::exists).flatMap(root -> Stream.of(new File((File)root, "work"), new File((File)root, "temp"), new File((File)root, "tmp"))).filter(File::exists).findFirst().orElseGet(() -> new File(System.getProperty("java.io.tmpdir", "."))), System.getProperty("geronimo.metrics.sigar.folder", "sigar"));
    }
}

