/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.extension.sigar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;

public class InitSigar {
    private boolean valid;
    private final File tempDir;

    public InitSigar(File tempDir) {
        this.tempDir = tempDir;
    }

    public void ensureSigarIsSetup() {
        this.valid = true;
        SigarLoader loader = new SigarLoader(Sigar.class);
        try {
            this.loadFromPath(loader);
        }
        catch (UnsatisfiedLinkError e) {
            this.unavailable(e.getMessage());
        }
    }

    private void loadFromPath(SigarLoader loader) {
        block24: {
            try {
                String systemProp = loader.getPackageName() + ".path";
                String path = System.getProperty(systemProp);
                if (path == null) {
                    String libraryName = loader.getLibraryName();
                    File output = new File(this.tempDir, "sigar/" + libraryName);
                    if (output.exists()) break block24;
                    int dot = libraryName.lastIndexOf(46);
                    String resourceName = libraryName.substring(0, dot) + "-" + System.getProperty("sigar.version", "1.6.4") + libraryName.substring(dot);
                    try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);){
                        if (stream == null) {
                            this.unavailable("native library not found in the classloader as " + resourceName);
                            return;
                        }
                        output.getParentFile().mkdirs();
                        Files.copy(stream, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        loader.load(output.getParentFile().getAbsolutePath());
                        this.afterLoad(systemProp);
                        break block24;
                    }
                    catch (IOException | ArchLoaderException ex) {
                        this.unavailable(ex.getMessage());
                    }
                    break block24;
                }
                if (!"-".equals(path)) {
                    try {
                        loader.load(path);
                        this.afterLoad(systemProp);
                    }
                    catch (ArchLoaderException ex) {
                        this.unavailable(ex.getMessage());
                    }
                }
            }
            catch (ArchNotSupportedException ex) {
                this.unavailable(ex.getMessage());
            }
        }
    }

    private void unavailable(String message) {
        Logger.getLogger(InitSigar.class.getName()).info("Sigar is not available: " + message);
        this.valid = false;
    }

    private void afterLoad(String systemProp) {
        String original = System.getProperty(systemProp);
        System.setProperty(systemProp, "-");
        try {
            this.testItWorks();
        }
        catch (Throwable throwable) {
            this.unavailable(throwable.getMessage());
            if (original == null) {
                System.clearProperty(systemProp);
            }
            System.setProperty(systemProp, original);
        }
    }

    private void testItWorks() throws SigarException {
        Sigar sigar = new Sigar();
        sigar.getCpu();
        sigar.close();
    }

    public boolean isValid() {
        return this.valid;
    }
}

