/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.extension.common;

import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.geronimo.microprofile.metrics.extension.common.Definition;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public class MicroprofileMetricsAdapter {
    private final MetricRegistry registry;

    public MicroprofileMetricsAdapter(MetricRegistry registry) {
        this.registry = registry;
    }

    public Consumer<Definition> registrer() {
        return def -> {
            Metadata metadata = new Metadata(def.getName(), def.getDisplayName(), def.getDescription(), MetricType.GAUGE, def.getUnit());
            metadata.setReusable(true);
            try {
                this.registry.register(metadata, (Metric)((Gauge)() -> def.getEvaluator().getAsDouble()));
            }
            catch (RuntimeException re) {
                Logger.getLogger(MicroprofileMetricsAdapter.class.getName()).fine(re.getMessage());
            }
        };
    }

    public Consumer<Definition> unregistrer() {
        return def -> this.registry.remove(def.getName());
    }
}

