/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.extension.common;

import java.util.Objects;
import java.util.function.DoubleSupplier;
import org.apache.geronimo.microprofile.metrics.extension.common.ThrowingSupplier;

public class Definition {
    private final String name;
    private final String displayName;
    private final String description;
    private final String unit;
    private final DoubleSupplier evaluator;
    private final int hash;

    public Definition(String name, String displayName, String description, String unit, ThrowingSupplier<Number> evaluator) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.unit = unit;
        this.evaluator = () -> {
            try {
                return ((Number)evaluator.get()).doubleValue();
            }
            catch (Throwable throwable) {
                return -1.0;
            }
        };
        this.hash = Objects.hash(name);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public DoubleSupplier getEvaluator() {
        return this.evaluator;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return Objects.equals(this.name, ((Definition)Definition.class.cast((Object)that)).name);
    }

    public int hashCode() {
        return this.hash;
    }
}

