/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.servlet;

import java.security.Principal;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.geronimo.microprofile.impl.jwtauth.JwtException;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.JwtParser;
import org.apache.geronimo.microprofile.impl.jwtauth.servlet.TokenAccessor;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JwtRequest
extends HttpServletRequestWrapper
implements TokenAccessor {
    private final Supplier<JsonWebToken> tokenExtractor;
    private final String headerName;
    private volatile JsonWebToken token;

    public JwtRequest(JwtParser service, String header, String cookie, String prefix, HttpServletRequest request) {
        super(request);
        this.headerName = header;
        this.tokenExtractor = () -> {
            if (this.token != null) {
                return this.token;
            }
            JwtRequest jwtRequest = this;
            synchronized (jwtRequest) {
                Cookie[] cookies;
                if (this.token != null) {
                    return this.token;
                }
                Object existing = this.getAttribute(JsonWebToken.class.getName());
                if (existing != null) {
                    this.token = JsonWebToken.class.isInstance(existing) ? (JsonWebToken)JsonWebToken.class.cast(existing) : service.parse(String.valueOf(existing));
                    return this.token;
                }
                boolean fromHeader = true;
                String auth = (String)String.class.cast(this.getAttribute("org.apache.geronimo.microprofile.impl.jwtauth.jaxrs.JAXRSRequestForwarder.header"));
                if (auth == null) {
                    auth = this.getHeader(header);
                }
                if (auth == null && (cookies = this.getCookies()) != null) {
                    fromHeader = false;
                    auth = Stream.of(cookies).filter(it -> cookie.equalsIgnoreCase(it.getName())).findFirst().map(Cookie::getValue).orElse(null);
                }
                if (auth == null || auth.isEmpty()) {
                    throw new JwtException("No " + header + " header", 401);
                }
                if (fromHeader) {
                    if (!auth.toLowerCase(Locale.ROOT).startsWith(prefix)) {
                        throw new JwtException("No prefix " + prefix + " in header " + header, 401);
                    }
                    this.token = service.parse(auth.substring(prefix.length()));
                } else {
                    this.token = service.parse(auth.startsWith(prefix) ? auth.substring(prefix.length()) : auth);
                }
                this.setAttribute(JsonWebToken.class.getName(), this.token);
                return this.token;
            }
        };
        this.setAttribute(JwtRequest.class.getName(), this);
        this.setAttribute(JsonWebToken.class.getName() + ".supplier", this.tokenExtractor);
        this.setAttribute(Principal.class.getName() + ".supplier", this.tokenExtractor);
        this.setAttribute("javax.security.auth.subject.callable", () -> {
            LinkedHashSet<JsonWebToken> principals = new LinkedHashSet<JsonWebToken>();
            JsonWebToken namePrincipal = this.tokenExtractor.get();
            principals.add(namePrincipal);
            principals.addAll(namePrincipal.getGroups().stream().map(role -> () -> role).collect(Collectors.toList()));
            return new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
        });
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public TokenAccessor asTokenAccessor() {
        return this;
    }

    @Override
    public JsonWebToken getToken() {
        return this.tokenExtractor.get();
    }

    public Principal getUserPrincipal() {
        return (Principal)this.tokenExtractor.get();
    }

    public boolean isUserInRole(String role) {
        return this.tokenExtractor.get().getGroups().contains(role);
    }

    public String getAuthType() {
        return "MP-JWT";
    }
}

