/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.servlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.microprofile.impl.jwtauth.JwtException;
import org.apache.geronimo.microprofile.impl.jwtauth.cdi.GeronimoJwtAuthExtension;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.JwtParser;
import org.apache.geronimo.microprofile.impl.jwtauth.servlet.JwtRequest;

public class GeronimoJwtAuthFilter
implements Filter {
    private String headerName;
    private String cookieName;
    private String prefix;
    private JwtParser service;
    private GeronimoJwtAuthExtension extension;
    private Collection<String> publicUrls;

    public void init(FilterConfig filterConfig) {
        CDI current = CDI.current();
        this.service = (JwtParser)current.select(JwtParser.class, new Annotation[0]).get();
        this.extension = (GeronimoJwtAuthExtension)current.select(GeronimoJwtAuthExtension.class, new Annotation[0]).get();
        GeronimoJwtAuthConfig config = (GeronimoJwtAuthConfig)current.select(GeronimoJwtAuthConfig.class, new Annotation[0]).get();
        this.headerName = config.read("header.name", "Authorization");
        this.cookieName = config.read("cookie.name", "Bearer");
        this.prefix = Optional.of(config.read("header.prefix", "bearer")).filter(s -> !s.isEmpty()).map(s -> s + " ").orElse("");
        this.publicUrls = Stream.of(config.read("filter.publicUrls", "").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(request)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
        if (!this.publicUrls.isEmpty()) {
            String current = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
            if (this.publicUrls.stream().anyMatch(current::startsWith)) {
                chain.doFilter(request, response);
                return;
            }
        }
        try {
            JwtRequest req = new JwtRequest(this.service, this.headerName, this.cookieName, this.prefix, httpServletRequest);
            this.extension.execute(req.asTokenAccessor(), () -> chain.doFilter((ServletRequest)req, response));
        }
        catch (Exception e) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)HttpServletResponse.class.cast(response);
            if (!httpServletResponse.isCommitted()) {
                for (Throwable current = e; current != null; current = current.getCause()) {
                    if (JwtException.class.isInstance(current)) {
                        JwtException ex = (JwtException)JwtException.class.cast(current);
                        httpServletResponse.sendError(ex.getStatus(), ex.getMessage());
                        return;
                    }
                    if (current == current.getCause()) break;
                }
            }
            throw e;
        }
    }

    public void destroy() {
    }
}

