/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jwt;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

class GeronimoJsonWebToken
implements JsonWebToken {
    private final JsonObject delegate;
    private final String raw;

    GeronimoJsonWebToken(String raw, JsonObject delegate) {
        this.raw = raw;
        this.delegate = delegate;
    }

    public String getName() {
        return (String)this.getClaim(Claims.upn.name());
    }

    public Set<String> getClaimNames() {
        return this.delegate.keySet();
    }

    public <T> T getClaim(String claimName) {
        try {
            Claims claim = Claims.valueOf((String)claimName);
            if (claim == Claims.raw_token) {
                return (T)this.raw;
            }
            if (claim.getType() == String.class) {
                return (T)this.delegate.getString(claimName);
            }
            if (claim.getType() == Long.class) {
                return (T)Long.valueOf(this.delegate.getJsonNumber(claimName).longValue());
            }
            if (claim.getType() == JsonObject.class) {
                return (T)this.delegate.getJsonObject(claimName);
            }
            if (claim.getType() == Set.class) {
                JsonValue jsonValue = (JsonValue)this.delegate.get((Object)claimName);
                if (jsonValue == null) {
                    return null;
                }
                if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
                    return (T)((JsonArray)JsonArray.class.cast(jsonValue)).stream().map(this::toString).collect(Collectors.toSet());
                }
                if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                    return (T)Stream.of(((JsonString)JsonString.class.cast(jsonValue)).getString().split(",")).collect(Collectors.toSet());
                }
                return (T)jsonValue;
            }
            return (T)this.delegate.get((Object)claimName);
        }
        catch (IllegalArgumentException iae) {
            return (T)this.delegate.get((Object)claimName);
        }
    }

    private String toString(Object value) {
        if (JsonString.class.isInstance(value)) {
            return ((JsonString)JsonString.class.cast(value)).getString();
        }
        if (JsonNumber.class.isInstance(value)) {
            return String.valueOf(((JsonNumber)JsonNumber.class.cast(value)).doubleValue());
        }
        return value.toString();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

