/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.apache.geronimo.microprofile.impl.jwtauth.jaxrs.GroupMapper;
import org.apache.geronimo.microprofile.impl.jwtauth.jaxrs.RolesAllowedRequestFilter;

@Provider
@Dependent
public class RolesAllowedFeature
implements DynamicFeature {
    @Inject
    private GroupMapper mapper;

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Map<Class<?>, Annotation> methodAnnotations = this.collectConfig(resourceInfo.getResourceMethod());
        if (methodAnnotations.size() > 1) {
            throw new IllegalArgumentException("Ambiguous configuration for " + resourceInfo.getResourceMethod() + ": " + methodAnnotations);
        }
        Map<Class<?>, Annotation> classAnnotations = this.collectConfig(this.unwrapClazz(resourceInfo.getResourceClass()));
        if (classAnnotations.size() > 1) {
            throw new IllegalArgumentException("Ambiguous configuration for " + resourceInfo.getResourceClass() + ": " + classAnnotations);
        }
        if (classAnnotations.isEmpty() && methodAnnotations.isEmpty()) {
            return;
        }
        try {
            Optional.ofNullable(RolesAllowedFeature.class.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass("javax.annotation.security.PermitAll");
        }
        catch (ClassNotFoundException cnfe) {
            return;
        }
        boolean denyAll = methodAnnotations.containsKey(DenyAll.class) || methodAnnotations.isEmpty() && classAnnotations.containsKey(DenyAll.class);
        boolean permitAll = !denyAll && (methodAnnotations.containsKey(PermitAll.class) || methodAnnotations.isEmpty() && classAnnotations.containsKey(PermitAll.class));
        List<String> roles = denyAll || permitAll ? Collections.emptyList() : (Collection)Stream.of(((RolesAllowed)RolesAllowed.class.cast(Optional.ofNullable(methodAnnotations.get(RolesAllowed.class)).orElseGet(() -> (Annotation)classAnnotations.get(RolesAllowed.class)))).value()).flatMap(it -> this.mapper.map((String)it).stream()).collect(Collectors.toSet());
        featureContext.register((Object)new RolesAllowedRequestFilter(denyAll, permitAll, roles));
    }

    private Map<Class<?>, Annotation> collectConfig(AnnotatedElement annotatedElement) {
        return Stream.of(DenyAll.class, PermitAll.class, RolesAllowed.class).filter(annotatedElement::isAnnotationPresent).map(annotatedElement::getAnnotation).collect(Collectors.toMap(Annotation::annotationType, Function.identity()));
    }

    private AnnotatedElement unwrapClazz(Class<?> resourceClass) {
        Class<?> current = resourceClass;
        while (current.getName().contains("$$") && current.getSuperclass() != null) {
            current = current.getSuperclass();
        }
        return current;
    }
}

