/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.cdi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.inject.Provider;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.ContextualJsonWebToken;
import org.apache.geronimo.microprofile.impl.jwtauth.servlet.JwtRequest;
import org.apache.geronimo.microprofile.impl.jwtauth.servlet.TokenAccessor;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class GeronimoJwtAuthExtension
implements Extension {
    private final ThreadLocal<TokenAccessor> request = new ThreadLocal();
    private final Collection<Injection> injectionPoints = new HashSet<Injection>(8);
    private final Collection<Throwable> errors = new ArrayList<Throwable>();
    private JsonProvider json;

    void setClaimMethodsBinding(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        beforeBeanDiscovery.configureQualifier(Claim.class).methods().forEach(m -> m.remove(it -> it.annotationType() == Nonbinding.class));
        this.json = JsonProvider.provider();
    }

    void captureInjections(@Observes ProcessInjectionPoint<?, ?> processInjectionPoint) {
        InjectionPoint injectionPoint = processInjectionPoint.getInjectionPoint();
        Optional.ofNullable(injectionPoint.getAnnotated().getAnnotation(Claim.class)).flatMap(claim -> this.createInjection((Claim)claim, injectionPoint.getType())).ifPresent(this.injectionPoints::add);
    }

    void addClaimBeans(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        afterBeanDiscovery.addBean().id(GeronimoJwtAuthExtension.class.getName() + "#" + GeronimoJwtAuthConfig.class.getName()).beanClass(GeronimoJwtAuthConfig.class).types(new Type[]{GeronimoJwtAuthConfig.class, Object.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(ctx -> GeronimoJwtAuthConfig.create());
        afterBeanDiscovery.addBean().id(GeronimoJwtAuthExtension.class.getName() + "#" + JsonWebToken.class.getName()).beanClass(JsonWebToken.class).types(new Type[]{JsonWebToken.class, Object.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(ctx -> new ContextualJsonWebToken(() -> {
            TokenAccessor request = this.request.get();
            if (request == null) {
                throw new IllegalStateException("No JWT in this request");
            }
            return request.getToken();
        }));
        this.injectionPoints.forEach(injection -> afterBeanDiscovery.addBean().id(GeronimoJwtAuthExtension.class.getName() + "#" + ((Injection)injection).getId()).beanClass(((Injection)injection).findClass()).qualifiers(new Annotation[]{((Injection)injection).literal(), Any.Literal.INSTANCE}).scope(((Injection)injection).findScope()).types(new Type[]{((Injection)injection).type, Object.class}).createWith(ctx -> injection.createInstance(this.request.get())));
        this.injectionPoints.clear();
    }

    void afterDeployment(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.errors.forEach(arg_0 -> ((AfterDeploymentValidation)afterDeploymentValidation).addDeploymentProblem(arg_0));
    }

    private Optional<Injection> createInjection(Claim claim, Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            if (pt.getActualTypeArguments().length == 1) {
                Type raw = pt.getRawType();
                Type arg = pt.getActualTypeArguments()[0];
                if (raw == Provider.class || raw == Instance.class) {
                    return this.createInjection(claim, arg);
                }
                if (raw == Optional.class) {
                    return this.createInjection(claim, arg).map(it -> new Injection(claim.value(), claim.standard(), type, (Injection)it){
                        final /* synthetic */ Injection val$it;
                        {
                            this.val$it = injection;
                            super(name, claims, type);
                        }

                        @Override
                        Object createInstance(TokenAccessor jwtRequest) {
                            return Optional.ofNullable(this.val$it.createInstance(jwtRequest));
                        }
                    });
                }
                if (raw == ClaimValue.class) {
                    final String name = GeronimoJwtAuthExtension.getClaimName(claim);
                    return this.createInjection(claim, arg).map(it -> new Injection(claim.value(), claim.standard(), type, (Injection)it){
                        final /* synthetic */ Injection val$it;
                        {
                            this.val$it = injection;
                            super(name2, claims, type);
                        }

                        @Override
                        Object createInstance(final TokenAccessor jwtRequest) {
                            return new ClaimValue<Object>(){

                                public String getName() {
                                    return name;
                                }

                                public Object getValue() {
                                    return val$it.createInstance(jwtRequest);
                                }
                            };
                        }
                    });
                }
                if (Class.class.isInstance(raw) && Collection.class.isAssignableFrom((Class)Class.class.cast(raw))) {
                    return Optional.of(new Injection(claim.value(), claim.standard(), type));
                }
            }
        } else if (Class.class.isInstance(type)) {
            Class clazz = (Class)Class.class.cast(type);
            if (JsonValue.class.isAssignableFrom(clazz)) {
                if (JsonString.class.isAssignableFrom(clazz)) {
                    return Optional.of(new Injection(claim.value(), claim.standard(), clazz){

                        @Override
                        Object createInstance(TokenAccessor jwtRequest) {
                            Object instance = super.createInstance(jwtRequest);
                            if (JsonString.class.isInstance(instance)) {
                                return instance;
                            }
                            return GeronimoJwtAuthExtension.this.json.createValue((String)String.class.cast(instance));
                        }
                    });
                }
                if (JsonNumber.class.isAssignableFrom(clazz)) {
                    return Optional.of(new Injection(claim.value(), claim.standard(), clazz){

                        @Override
                        Object createInstance(TokenAccessor jwtRequest) {
                            Object instance = super.createInstance(jwtRequest);
                            if (JsonNumber.class.isInstance(instance)) {
                                return instance;
                            }
                            return GeronimoJwtAuthExtension.this.json.createValue(((Number)Number.class.cast(instance)).doubleValue());
                        }
                    });
                }
                if (JsonObject.class.isAssignableFrom(clazz)) {
                    return Optional.of(new Injection(claim.value(), claim.standard(), clazz));
                }
                if (JsonArray.class.isAssignableFrom(clazz)) {
                    return Optional.of(new Injection(claim.value(), claim.standard(), clazz){

                        @Override
                        Object createInstance(TokenAccessor jwtRequest) {
                            Object instance = super.createInstance(jwtRequest);
                            if (instance == null) {
                                return null;
                            }
                            if (JsonArray.class.isInstance(instance)) {
                                return instance;
                            }
                            if (Set.class.isInstance(instance)) {
                                return ((Set)instance).stream().collect(Collector.of(() -> ((JsonProvider)GeronimoJwtAuthExtension.this.json).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0]));
                            }
                            throw new IllegalArgumentException("Unsupported value: " + instance);
                        }
                    });
                }
            } else {
                Class<?> objectType = this.wrapPrimitives(clazz);
                if (CharSequence.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(objectType) || Long.class.isAssignableFrom(objectType) || Integer.class.isAssignableFrom(objectType)) {
                    return Optional.of(new Injection(claim.value(), claim.standard(), objectType));
                }
            }
        }
        this.errors.add(new IllegalArgumentException(type + " not supported by JWT-Auth implementation"));
        return Optional.empty();
    }

    private Class<?> wrapPrimitives(Class<?> type) {
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        return type;
    }

    private static String getClaimName(Claim claim) {
        return GeronimoJwtAuthExtension.getClaimName(claim.value(), claim.standard());
    }

    private static String getClaimName(String name, Claims val) {
        return Optional.of(name).filter(s -> !s.isEmpty()).orElse(val.name());
    }

    public void execute(HttpServletRequest req, ServletRunnable task) {
        try {
            TokenAccessor jwtRequest = Objects.requireNonNull(JwtRequest.class.isInstance(req) ? (JwtRequest)JwtRequest.class.cast(req) : (JwtRequest)JwtRequest.class.cast(req.getAttribute(JwtRequest.class.getName())), "No JwtRequest");
            this.execute(jwtRequest, task);
        }
        catch (IOException | ServletException e) {
            throw new IllegalStateException(e);
        }
    }

    public void execute(TokenAccessor req, ServletRunnable task) throws ServletException, IOException {
        this.request.set(req);
        try {
            task.run();
        }
        finally {
            this.request.remove();
        }
    }

    @Vetoed
    private static class ClaimLiteral
    extends AnnotationLiteral<Claim>
    implements Claim {
        private final String name;
        private final Claims claims;

        private ClaimLiteral(String name, Claims claims) {
            this.name = name;
            this.claims = claims;
        }

        public String value() {
            return this.name;
        }

        public Claims standard() {
            return this.claims;
        }
    }

    private static class Injection {
        private final String name;
        private final Claims claims;
        private final Type type;
        private final int hash;
        private final Function<Object, Object> transformer;
        private final String runtimeName;

        private Injection(String name, Claims claims, Type type) {
            Function<Object, Object> transformer;
            this.name = name;
            this.claims = claims;
            this.type = type;
            try {
                Claims.valueOf((String)GeronimoJwtAuthExtension.getClaimName(name, claims));
                transformer = Function.identity();
            }
            catch (IllegalArgumentException iae) {
                transformer = type == String.class ? val -> val == null ? null : ((JsonString)JsonString.class.cast(val)).getString() : (type == Long.class ? val -> val == null ? null : Long.valueOf(((JsonNumber)JsonNumber.class.cast(val)).longValue()) : Function.identity());
            }
            this.transformer = transformer;
            this.runtimeName = GeronimoJwtAuthExtension.getClaimName(name, claims);
            int result = name.hashCode();
            result = 31 * result + claims.hashCode();
            this.hash = 31 * result + type.hashCode();
        }

        private String getId() {
            return this.name + "/" + this.claims + "/" + this.type;
        }

        private Class<?> findClass() {
            if (Class.class.isInstance(this.type)) {
                return (Class)Class.class.cast(this.type);
            }
            if (ParameterizedType.class.isInstance(this.type)) {
                ParameterizedType current = (ParameterizedType)ParameterizedType.class.cast(this.type);
                while (!Class.class.isInstance(current.getRawType())) {
                    current = (ParameterizedType)ParameterizedType.class.cast(current.getRawType());
                }
                return (Class)Class.class.cast(current.getRawType());
            }
            throw new IllegalArgumentException("Can't find a class from " + this.type);
        }

        private Class<? extends Annotation> findScope() {
            if (ClaimValue.class == this.findClass()) {
                return RequestScoped.class;
            }
            return Dependent.class;
        }

        private Annotation literal() {
            return new ClaimLiteral(this.name, this.claims);
        }

        Object createInstance(TokenAccessor jwtRequest) {
            return this.transformer.apply(jwtRequest.getToken().getClaim(this.runtimeName));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Injection injection = (Injection)Injection.class.cast(o);
            return this.runtimeName.equals(injection.runtimeName) && this.type.equals(injection.type);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "Injection{claim='" + this.runtimeName + "', type=" + this.type + '}';
        }
    }

    @FunctionalInterface
    public static interface ServletRunnable {
        public void run() throws ServletException, IOException;
    }
}

