/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.geronimo.jcache.simple.Asserts;
import org.apache.geronimo.jcache.simple.SimpleCache;
import org.apache.geronimo.jcache.simple.Statistics;

public class TempStateCacheView<K, V>
implements Cache<K, V> {
    private final SimpleCache<K, V> cache;
    private final Map<K, V> put = new HashMap();
    private final Collection<K> remove = new LinkedList<K>();
    private boolean removeAll = false;
    private boolean clear = false;

    public TempStateCacheView(SimpleCache<K, V> entries) {
        this.cache = entries;
    }

    public V get(K key) {
        if (this.ignoreKey(key)) {
            return null;
        }
        V v = this.put.get(key);
        if (v != null) {
            return v;
        }
        if (this.cache.getConfiguration(CompleteConfiguration.class).isStatisticsEnabled()) {
            Statistics statistics = this.cache.getStatistics();
            if (this.cache.containsKey(key)) {
                statistics.increaseHits(-1L);
            } else {
                statistics.increaseMisses(-1L);
            }
        }
        return this.cache.get(key);
    }

    private boolean ignoreKey(K key) {
        return this.removeAll || this.clear || this.remove.contains(key);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        HashMap<K, V> v = new HashMap<K, V>(keys.size());
        HashSet<K> missing = new HashSet<K>();
        for (K k : keys) {
            V value = this.put.get(k);
            if (value != null) {
                v.put(k, value);
                continue;
            }
            if (this.ignoreKey(k)) continue;
            missing.add(k);
        }
        if (!missing.isEmpty()) {
            v.putAll(this.cache.getAll(missing));
        }
        return v;
    }

    public boolean containsKey(K key) {
        return !this.ignoreKey(key) && (this.put.containsKey(key) || this.cache.containsKey(key));
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.cache.loadAll(keys, replaceExistingValues, completionListener);
    }

    public void put(K key, V value) {
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(value, "value");
        this.put.put(key, value);
        this.remove.remove(key);
    }

    public V getAndPut(K key, V value) {
        V v = this.get(key);
        this.put(key, value);
        return v;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.put.putAll(map);
        for (K k : map.keySet()) {
            this.remove.remove(k);
        }
    }

    public boolean putIfAbsent(K key, V value) {
        if (!this.put.containsKey(key)) {
            this.put.put(key, value);
            this.remove.remove(key);
            return true;
        }
        return false;
    }

    public boolean remove(K key) {
        boolean noop = this.put.containsKey(key);
        this.put.remove(key);
        if (!this.ignoreKey(key)) {
            if (!noop) {
                this.remove.add(key);
            }
            return true;
        }
        return false;
    }

    public boolean remove(K key, V oldValue) {
        this.put.remove(key);
        if (!this.ignoreKey(key) && oldValue.equals(this.cache.get(key))) {
            this.remove.add(key);
            return true;
        }
        return false;
    }

    public V getAndRemove(K key) {
        V v = this.get(key);
        this.remove.add(key);
        this.put.remove(key);
        return v;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        if (oldValue.equals(this.get(key))) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    public boolean replace(K key, V value) {
        if (this.containsKey(key)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public V getAndReplace(K key, V value) {
        if (this.containsKey(key)) {
            V oldValue = this.get(key);
            this.put(key, value);
            return oldValue;
        }
        return null;
    }

    public void removeAll(Set<? extends K> keys) {
        this.remove.addAll(keys);
        for (K k : keys) {
            this.put.remove(k);
        }
    }

    public void removeAll() {
        this.removeAll = true;
        this.put.clear();
        this.remove.clear();
    }

    public void clear() {
        this.clear = true;
        this.put.clear();
        this.remove.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return this.cache.getConfiguration(clazz);
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        return this.cache.invoke(key, entryProcessor, arguments);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        return this.cache.invokeAll(keys, entryProcessor, arguments);
    }

    public String getName() {
        return this.cache.getName();
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public void close() {
        this.cache.close();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        return this.cache.unwrap(clazz);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.cache.registerCacheEntryListener(cacheEntryListenerConfiguration);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.cache.deregisterCacheEntryListener(cacheEntryListenerConfiguration);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        return this.cache.iterator();
    }

    public void merge() {
        if (this.removeAll) {
            this.cache.removeAll();
        }
        if (this.clear) {
            this.cache.clear();
        }
        for (Map.Entry<K, V> entry : this.put.entrySet()) {
            this.cache.put(entry.getKey(), entry.getValue());
        }
        this.put.clear();
        for (Map.Entry<K, V> entry : this.remove) {
            this.cache.remove(entry);
        }
        this.remove.clear();
    }
}

