/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_IDX = new AtomicInteger();
    private final AtomicInteger threadIdx = new AtomicInteger();
    private final int poolIdx;
    private final String format;

    public SimpleThreadFactory(String format) {
        this.format = format;
        this.poolIdx = POOL_IDX.incrementAndGet();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setName(String.format(this.format, this.poolIdx, this.threadIdx.incrementAndGet()));
        thread.setPriority(5);
        thread.setDaemon(false);
        return thread;
    }
}

