/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.genesis.plugins.tools;

import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.dependency.DependencyHelper;
import org.codehaus.mojo.pluginsupport.dependency.DependencyTree;

public class ShowDependenciesMojo
extends MojoSupport {
    private boolean verbose = false;
    private DependencyHelper helper = null;
    protected MavenProject project;
    protected ArtifactRepository repository;

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.helper.setArtifactRepository(this.repository);
    }

    protected void doExecute() throws Exception {
        DependencyTree dependencies = this.helper.getDependencies(this.project);
        this.printDependencyListing(dependencies.getRootNode(), "");
    }

    private void printDependencyListing(DependencyTree.Node node, String pad) {
        Artifact artifact = node.getArtifact();
        String id = artifact.getDependencyConflictId();
        StringBuffer buff = new StringBuffer(id);
        if (this.verbose) {
            buff.append(" ");
            buff.append("{ version=").append(artifact.getVersion());
            buff.append(", scope=").append(artifact.getScope());
            buff.append(" }");
        }
        this.log.info((CharSequence)(pad + buff));
        if (!node.getChildren().isEmpty()) {
            Iterator children = node.getChildren().iterator();
            while (children.hasNext()) {
                DependencyTree.Node child = (DependencyTree.Node)children.next();
                this.printDependencyListing(child, pad + "    ");
            }
        }
    }
}

