/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.genesis.plugins.tools;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.ant.AntHelper;
import org.codehaus.plexus.util.DirectoryScanner;

public class CopyLegalFilesMojo
extends MojoSupport {
    private static final String[] DEFAULT_INCLUDES;
    private File outputDirectory = null;
    protected File basedir;
    private DirectoryScanner fileset;
    private boolean strict;
    private AntHelper ant;
    protected MavenProject project = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MavenProject getProject() {
        return this.project;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.ant.setProject(this.getProject());
    }

    protected void doExecute() throws Exception {
        if (!this.shouldInstallLegalFiles(this.getProject())) {
            return;
        }
        if (this.fileset == null) {
            this.fileset = new DirectoryScanner();
            this.fileset.setBasedir(this.basedir);
            this.fileset.setIncludes(DEFAULT_INCLUDES);
        }
        this.fileset.addDefaultExcludes();
        this.fileset.scan();
        String[] filenames = this.fileset.getIncludedFiles();
        if (filenames.length == 0) {
            if (this.strict) {
                throw new MojoExecutionException("No legal files found to copy");
            }
            this.log.warn((CharSequence)"No legal files found to copy");
            return;
        }
        this.ant.mkdir(this.outputDirectory);
        Copy copy = (Copy)this.ant.createTask("copy");
        copy.setTodir(this.outputDirectory);
        FileSet files = this.ant.createFileSet();
        files.setDir(this.basedir);
        for (int i = 0; i < filenames.length; ++i) {
            files.createInclude().setName(filenames[i]);
        }
        copy.addFileset(files);
        copy.execute();
    }

    private boolean shouldInstallLegalFiles(MavenProject project) {
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        return !"pom".equals(this.getProject().getPackaging());
    }

    static {
        $assertionsDisabled = !CopyLegalFilesMojo.class.desiredAssertionStatus();
        DEFAULT_INCLUDES = new String[]{"LICENSE.txt", "LICENSE", "NOTICE.txt", "NOTICE", "DISCLAIMER.txt", "DISCLAIMER"};
    }
}

