/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.StartupMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilentStartupMonitor
implements StartupMonitor {
    private static final Logger log = LoggerFactory.getLogger(SilentStartupMonitor.class);
    private Kernel kernel;

    @Override
    public void systemStarting(long startTime) {
    }

    @Override
    public void systemStarted(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void foundModules(Artifact[] modules) {
    }

    @Override
    public void moduleLoading(Artifact module) {
    }

    @Override
    public void moduleLoaded(Artifact module) {
    }

    @Override
    public void moduleStarting(Artifact module) {
    }

    @Override
    public void moduleStarted(Artifact module) {
    }

    @Override
    public void startupFinished() {
        try {
            Set gbeans = this.kernel.listGBeans((AbstractNameQuery)null);
            for (AbstractName name : gbeans) {
                int state = this.kernel.getGBeanState(name);
                if (state == 1) continue;
                log.warn("Unable to start {} ({})", (Object)name, (Object)State.fromInt((int)state).getName());
            }
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
        System.out.println("Geronimo startup complete");
    }

    @Override
    public void serverStartFailed(Exception problem) {
        System.out.println("Geronimo startup failed:");
        problem.printStackTrace(System.out);
    }
}

