/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.PrintStream;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.StartupMonitor;
import org.apache.geronimo.system.main.StartupMonitorUtil;
import org.apache.geronimo.system.serverinfo.ServerConstants;

public class ProgressBarStartupMonitor
implements StartupMonitor {
    private static final char STATUS_NOT_READY = ' ';
    private static final char STATUS_LOADING = '-';
    private static final char STATUS_LOADED = '>';
    private static final char STATUS_STARTED = '*';
    private static final char STATUS_FAILED = 'x';
    private static final int MAX_WIDTH = 79;
    private PrintStream out;
    private String currentOperation;
    private Artifact[] modules;
    private char[] moduleStatus = new char[0];
    private long started;
    private int percent = 0;
    private Kernel kernel;
    private int operationLimit = 50;
    private boolean finished = false;
    private UpdateThread thread;

    @Override
    public synchronized void systemStarting(long startTime) {
        this.out = System.out;
        this.started = startTime;
    }

    @Override
    public synchronized void systemStarted(Kernel kernel) {
        this.out.println("Starting Geronimo Application Server v" + ServerConstants.getVersion());
        this.kernel = kernel;
        this.currentOperation = "Loading";
    }

    @Override
    public synchronized void foundModules(Artifact[] modules) {
        this.modules = modules;
        this.moduleStatus = new char[modules.length];
        for (int i = 0; i < this.moduleStatus.length; ++i) {
            this.moduleStatus[i] = 32;
        }
        this.operationLimit = 74 - modules.length - 4 - 5;
        this.repaint();
        this.thread = new UpdateThread();
        this.thread.start();
    }

    public synchronized void calculatePercent() {
        if (this.finished) {
            this.percent = 100;
            return;
        }
        int percent = 0;
        if (this.kernel != null) {
            percent += 5;
        }
        int total = this.moduleStatus.length * 2;
        int progress = 0;
        block4: for (int i = 0; i < this.moduleStatus.length; ++i) {
            char c = this.moduleStatus[i];
            switch (c) {
                case '>': {
                    ++progress;
                    continue block4;
                }
                case '*': 
                case 'x': {
                    progress += 2;
                }
            }
        }
        this.percent = percent += Math.round(90.0f * (float)progress / (float)total);
    }

    @Override
    public synchronized void moduleLoading(Artifact module) {
        this.currentOperation = " Loading " + module;
        for (int i = 0; i < this.modules.length; ++i) {
            if (!this.modules[i].equals((Object)module)) continue;
            this.moduleStatus[i] = 45;
        }
        this.repaint();
    }

    @Override
    public synchronized void moduleLoaded(Artifact module) {
        for (int i = 0; i < this.modules.length; ++i) {
            if (!this.modules[i].equals((Object)module)) continue;
            this.moduleStatus[i] = 62;
        }
        this.calculatePercent();
        this.repaint();
    }

    @Override
    public synchronized void moduleStarting(Artifact module) {
        this.currentOperation = "Starting " + module;
    }

    @Override
    public synchronized void moduleStarted(Artifact module) {
        for (int i = 0; i < this.modules.length; ++i) {
            if (!this.modules[i].equals((Object)module)) continue;
            this.moduleStatus[i] = 42;
        }
        this.calculatePercent();
        this.repaint();
    }

    @Override
    public synchronized void startupFinished() {
        this.finished = true;
        this.currentOperation = "Startup complete";
        this.calculatePercent();
        this.thread.done = true;
        this.thread.interrupt();
    }

    @Override
    public synchronized void serverStartFailed(Exception problem) {
        this.currentOperation = "Startup failed";
        this.repaint();
        this.out.println();
        problem.printStackTrace(this.out);
    }

    private synchronized void repaint() {
        StringBuilder buf = new StringBuilder();
        buf.append("\r[");
        buf.append(this.kernel == null ? (char)' ' : '*');
        for (int i = 0; i < this.moduleStatus.length; ++i) {
            buf.append(this.moduleStatus[i]);
        }
        buf.append(this.finished ? (char)'*' : ' ');
        buf.append("] ");
        if (this.percent < 10) {
            buf.append(' ');
        }
        buf.append(this.percent).append("% ");
        int time = Math.round((float)(System.currentTimeMillis() - this.started) / 1000.0f);
        if (time < 10) {
            buf.append(' ');
        }
        if (time < 100) {
            buf.append(' ');
        }
        buf.append(time).append("s ");
        if (this.currentOperation.length() > this.operationLimit) {
            if (this.operationLimit > 3) {
                buf.append(this.currentOperation.substring(0, this.operationLimit - 3)).append("...");
            } else {
                for (int i = 0; i < this.operationLimit; ++i) {
                    buf.append('.');
                }
            }
        } else {
            buf.append(this.currentOperation);
            for (int i = this.currentOperation.length(); i < this.operationLimit; ++i) {
                buf.append(' ');
            }
        }
        this.out.print(buf.toString());
        this.out.flush();
    }

    private class UpdateThread
    extends Thread {
        private volatile boolean done;

        public UpdateThread() {
            super("Progress Display Update Thread");
            this.done = false;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.done) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                ProgressBarStartupMonitor.this.repaint();
            }
            ProgressBarStartupMonitor.this.repaint();
            ProgressBarStartupMonitor.this.out.println();
            StartupMonitorUtil.wrapUp(ProgressBarStartupMonitor.this.out, ProgressBarStartupMonitor.this.kernel);
        }
    }
}

