/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.system.resolver.LocalAliasedArtifactResolver;
import org.apache.geronimo.system.serverinfo.ServerInfo;

@GBean(j2eeType="ArtifactResolver")
public class ExplicitDefaultArtifactResolver
extends DefaultArtifactResolver
implements LocalAliasedArtifactResolver {
    private static final String COMMENT = "#You can use this file to indicate that you want to substitute one module for another.\n#format is oldartifactid=newartifactId e.g.\n#org.apache.geronimo.configs/transaction//car=org.apache.geronimo.configs/transaction-jta11/1.2-SNAPSHOT/car\n#versions can be ommitted on the left side but not the right.\n#This can also specify explicit versions in the same format.";
    private final String artifactAliasesFile;
    private final ServerInfo serverInfo;

    public ExplicitDefaultArtifactResolver(String versionMapLocation, ArtifactManager artifactManager, Collection<ListableRepository> repositories, ServerInfo serverInfo) throws IOException {
        this(versionMapLocation, artifactManager, repositories, null, serverInfo, Collections.emptyList());
    }

    public ExplicitDefaultArtifactResolver(@ParamAttribute(name="versionMapLocation") String versionMapLocation, @ParamReference(name="ArtifactManager", namingType="ArtifactManager") ArtifactManager artifactManager, @ParamReference(name="Repositories", namingType="Repository") Collection<ListableRepository> repositories, @ParamAttribute(name="additionalAliases") Map<String, String> additionalAliases, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamReference(name="ConfigurationManagers", namingType="ConfigurationManager") Collection<ConfigurationManager> configurationManagers) throws IOException {
        super(artifactManager, repositories, ExplicitDefaultArtifactResolver.buildExplicitResolution(versionMapLocation, additionalAliases, serverInfo), configurationManagers);
        this.artifactAliasesFile = versionMapLocation;
        this.serverInfo = serverInfo;
    }

    @Override
    public String getArtifactAliasesFile() {
        return this.artifactAliasesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Artifact, Artifact> buildExplicitResolution(String versionMapLocation, Map<String, String> additionalAliases, ServerInfo serverInfo) throws IOException {
        File location;
        if (versionMapLocation == null) {
            return null;
        }
        Properties properties = new Properties();
        File file = location = serverInfo == null ? new File(versionMapLocation) : serverInfo.resolveServer(versionMapLocation);
        if (location.exists()) {
            FileInputStream in = new FileInputStream(location);
            try {
                properties.load(in);
            }
            finally {
                in.close();
            }
        }
        if (additionalAliases != null) {
            properties.putAll(additionalAliases);
        }
        return ExplicitDefaultArtifactResolver.propertiesToArtifactMap(properties);
    }

    private static Map<Artifact, Artifact> propertiesToArtifactMap(Properties properties) {
        HashMap<Artifact, Artifact> explicitResolution = new HashMap<Artifact, Artifact>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String resolvedString = (String)entry.getValue();
            Artifact source = Artifact.createPartial((String)key.trim());
            Artifact resolved = Artifact.create((String)resolvedString.trim());
            explicitResolution.put(source, resolved);
        }
        return explicitResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveExplicitResolution(Map<Artifact, Artifact> artifactMap, String versionMapLocation, ServerInfo serverInfo) throws IOException {
        File parent;
        File location;
        if (versionMapLocation == null) {
            return;
        }
        File file = location = serverInfo == null ? new File(versionMapLocation) : serverInfo.resolveServer(versionMapLocation);
        if (!(location.exists() || (parent = location.getParentFile()).exists() || parent.mkdirs())) {
            throw new IOException("Could not create directory for artifact aliases at " + parent);
        }
        FileOutputStream in = new FileOutputStream(location);
        Properties properties = ExplicitDefaultArtifactResolver.artifactMapToProperties(artifactMap);
        try {
            properties.store(in, COMMENT);
        }
        finally {
            in.close();
        }
    }

    private static Properties artifactMapToProperties(Map<Artifact, Artifact> artifactMap) {
        Properties properties = new Properties();
        for (Map.Entry<Artifact, Artifact> entry : artifactMap.entrySet()) {
            properties.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return properties;
    }

    @Override
    public synchronized void addAliases(Properties properties) throws IOException {
        Map<Artifact, Artifact> explicitResolutions = ExplicitDefaultArtifactResolver.propertiesToArtifactMap(properties);
        this.getExplicitResolution().putAll(explicitResolutions);
        ExplicitDefaultArtifactResolver.saveExplicitResolution(this.getExplicitResolution(), this.artifactAliasesFile, this.serverInfo);
    }

    public synchronized void removeAliases(Properties properties) throws IOException {
        Map<Artifact, Artifact> explicitResolutions = ExplicitDefaultArtifactResolver.propertiesToArtifactMap(properties);
        for (Map.Entry<Artifact, Artifact> entry : explicitResolutions.entrySet()) {
            this.getExplicitResolution().remove(entry.getKey());
        }
        ExplicitDefaultArtifactResolver.saveExplicitResolution(this.getExplicitResolution(), this.artifactAliasesFile, this.serverInfo);
    }

    public synchronized Properties getProperties() {
        return ExplicitDefaultArtifactResolver.artifactMapToProperties(this.getExplicitResolution());
    }
}

