/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.ImportType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="dependencyType", propOrder={"_import"})
public class DependencyType
extends ArtifactType
implements Serializable {
    private static final long serialVersionUID = 12343L;
    @XmlElement(name="import")
    protected ImportType _import;
    @XmlAttribute
    protected Boolean start;

    public ImportType getImport() {
        return this._import;
    }

    public void setImport(ImportType value) {
        this._import = value;
    }

    public boolean isStart() {
        if (this.start == null) {
            return true;
        }
        return this.start;
    }

    public void setStart(Boolean value) {
        this.start = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DependencyType that = (DependencyType)o;
        if (this._import != that._import) {
            return false;
        }
        return !(this.start != null ? !this.start.equals(that.start) : that.start != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this._import != null ? this._import.hashCode() : 0);
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DependencyType [" + this.getGroupId() + "/" + this.getArtifactId() + "/" + this.getVersion() + "/" + this.getType() + ":" + (Object)((Object)this.getImport()) + "]";
    }

    public static DependencyType newDependencyType(Dependency dependency) {
        DependencyType dependencyType = new DependencyType();
        dependencyType.setGroupId(dependency.getArtifact().getGroupId());
        dependencyType.setArtifactId(dependency.getArtifact().getArtifactId());
        if (dependency.getArtifact().getVersion() != null) {
            dependencyType.setVersion(dependency.getArtifact().getVersion().toString());
        }
        dependencyType.setType(dependency.getArtifact().getType());
        dependencyType.setImport(ImportType.fromValue(dependency.getImportType().getName()));
        return dependencyType;
    }
}

