/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationDataTransformer;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoOConfigurationDataTransformer;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.system.configuration.ConfigurationStoreUtil;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.configuration.InPlaceConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ConfigurationStore")
public class RepositoryConfigurationStore
implements ConfigurationStore {
    private static final Logger log = LoggerFactory.getLogger(RepositoryConfigurationStore.class);
    private final Kernel kernel;
    private final ObjectName objectName;
    private final AbstractName abstractName;
    protected final WritableListableRepository repository;
    private final InPlaceConfigurationUtil inPlaceConfUtil;
    private final ConfigurationDataTransformer transformer;
    public static final String GBEAN_REF_REPOSITORY = "Repository";
    public static final String GBEAN_REF_CONFIG_DATA_TRANSFORMER = "ConfigurationDataTransformer";

    public RepositoryConfigurationStore(WritableListableRepository repository) {
        this(null, null, null, repository, NoOConfigurationDataTransformer.SINGLETON);
    }

    public RepositoryConfigurationStore(Kernel kernel, String objectName, AbstractName abstractName, WritableListableRepository repository) {
        this(kernel, objectName, abstractName, repository, NoOConfigurationDataTransformer.SINGLETON);
    }

    public RepositoryConfigurationStore(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abstractName, @ParamReference(name="Repository", namingType="Repository") WritableListableRepository repository, @ParamReference(name="ConfigurationDataTransformer") ConfigurationDataTransformer transformer) {
        this.kernel = kernel;
        this.objectName = objectName == null ? null : ObjectNameUtil.getObjectName((String)objectName);
        this.abstractName = abstractName;
        this.repository = repository;
        this.transformer = null == transformer ? NoOConfigurationDataTransformer.SINGLETON : transformer;
        this.inPlaceConfUtil = new InPlaceConfigurationUtil();
    }

    public String getObjectName() {
        return this.objectName.getCanonicalName();
    }

    public AbstractName getAbstractName() {
        return this.abstractName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationData loadConfiguration(Artifact configId) throws NoSuchConfigException, IOException, InvalidConfigException {
        ConfigurationData configurationData;
        File location;
        block13: {
            if (!configId.isResolved()) {
                throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
            }
            location = this.repository.getLocation(configId);
            if (this.existsReadable(location)) {
                throw new NoSuchConfigException(configId);
            }
            try {
                if (location.isDirectory()) {
                    File serFile = new File(location, "META-INF");
                    if (!(serFile = new File(serFile, "config.ser")).exists()) {
                        throw new InvalidConfigException("Configuration does not contain a META-INF/config.ser file: " + serFile);
                    }
                    if (!serFile.canRead()) {
                        throw new InvalidConfigException("Can not read configuration META-INF/config.ser file: " + serFile);
                    }
                    ConfigurationStoreUtil.verifyChecksum(serFile);
                    FileInputStream in = new FileInputStream(serFile);
                    try {
                        configurationData = ConfigurationUtil.readConfigurationData((InputStream)in);
                        break block13;
                    }
                    finally {
                        IOUtils.close((Closeable)in);
                    }
                }
                JarFile jarFile = new JarFile(location);
                InputStream in = null;
                try {
                    ZipEntry entry = jarFile.getEntry("META-INF/config.ser");
                    in = jarFile.getInputStream(entry);
                    configurationData = ConfigurationUtil.readConfigurationData((InputStream)in);
                }
                catch (Throwable throwable) {
                    IOUtils.close(in);
                    JarUtils.close((JarFile)jarFile);
                    throw throwable;
                }
                IOUtils.close((Closeable)in);
                JarUtils.close((JarFile)jarFile);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigException("Unable to load class from config: " + configId, (Throwable)e);
            }
        }
        configurationData.setConfigurationDir(location);
        configurationData.setConfigurationStore((ConfigurationStore)this);
        if (this.kernel != null) {
            configurationData.setNaming(this.kernel.getNaming());
        }
        this.transformer.transformDependencies(configurationData);
        return configurationData;
    }

    private boolean existsReadable(File location) {
        return !location.exists() || !location.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsConfiguration(Artifact configId) {
        boolean bl;
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.isDirectory()) {
            location = new File(location, "META-INF");
            return (location = new File(location, "config.ser")).isFile() && location.canRead();
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(location);
            ZipEntry entry = jarFile.getEntry("META-INF/config.ser");
            bl = entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                JarUtils.close(jarFile);
                throw throwable;
            }
            JarUtils.close((JarFile)jarFile);
            return bl2;
        }
        JarUtils.close((JarFile)jarFile);
        return bl;
    }

    public File createNewConfigurationDir(Artifact configId) throws ConfigurationAlreadyExistsException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.exists()) {
            throw new ConfigurationAlreadyExistsException("Configuration already exists: " + configId);
        }
        File parentDirectory = location.getParentFile();
        if (!parentDirectory.exists()) {
            parentDirectory.mkdirs();
            if (log.isDebugEnabled()) {
                log.debug("Configuration directory: " + parentDirectory + " is created");
            }
        }
        return parentDirectory;
    }

    public Set<URL> resolve(Artifact configId, String moduleName, String path) throws NoSuchConfigException, MalformedURLException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.isDirectory()) {
            File inPlaceLocation = null;
            try {
                inPlaceLocation = this.inPlaceConfUtil.readInPlaceLocation(location);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (null != inPlaceLocation) {
                location = inPlaceLocation;
            }
            if (moduleName != null) {
                location = new File(location, moduleName);
            }
            return FileUtils.search((File)location, (String)path);
        }
        if (moduleName != null) {
            path = moduleName + "/" + path;
        }
        return FileUtils.search((File)location, (String)path);
    }

    public void exportConfiguration(Artifact configId, OutputStream output) throws IOException, NoSuchConfigException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File dir = this.repository.getLocation(configId);
        if (dir == null) {
            throw new NoSuchConfigException(configId);
        }
        if (this.existsReadable(dir)) {
            throw new IOException("Cannot read config store directory for " + configId + " (" + dir.getAbsolutePath() + ")");
        }
        ZipOutputStream out = new ZipOutputStream(output);
        byte[] buf = new byte[10240];
        this.writeToZip(dir, out, "", buf);
        if (this.inPlaceConfUtil.isInPlaceConfiguration(dir)) {
            dir = this.inPlaceConfUtil.readInPlaceLocation(dir);
            this.writeToZip(dir, out, "", buf);
        }
        out.closeEntry();
        out.finish();
        out.flush();
    }

    private void writeToZip(File dir, ZipOutputStream out, String prefix, byte[] buf) throws IOException {
        File[] all = dir.listFiles();
        if (all.length == 0) {
            ZipEntry entry = new ZipEntry(prefix);
            out.putNextEntry(entry);
        }
        for (File file : all) {
            if (file.isDirectory()) {
                this.writeToZip(file, out, prefix + file.getName() + "/", buf);
                continue;
            }
            ZipEntry entry = new ZipEntry(prefix + file.getName());
            out.putNextEntry(entry);
            this.writeToZipStream(file, out, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToZipStream(File file, OutputStream out, byte[] buf) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            int count;
            while ((count = in.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, count);
            }
        }
        finally {
            in.close();
        }
    }

    public boolean isInPlaceConfiguration(Artifact configId) throws NoSuchConfigException, IOException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.isDirectory()) {
            return this.inPlaceConfUtil.isInPlaceConfiguration(location);
        }
        return false;
    }

    public void install(ConfigurationData configurationData) throws IOException, InvalidConfigException {
        log.debug("Writing config: " + configurationData);
        File source = configurationData.getConfigurationDir();
        if (!source.exists()) {
            throw new InvalidConfigException("Source does not exist " + source);
        }
        if (!source.canRead()) {
            throw new InvalidConfigException("Source is not readable " + source);
        }
        ExecutableConfigurationUtil.writeConfiguration(configurationData, source);
        this.inPlaceConfUtil.writeInPlaceLocation(configurationData, source);
        Artifact configId = configurationData.getId();
        File destination = this.repository.getLocation(configId);
        if (!source.equals(destination)) {
            if (source.isFile()) {
                log.debug("copying packed bundle from " + source + " to destination " + destination);
                this.repository.copyToRepository(source, configId, null);
            } else {
                log.debug("Packing bundle from " + source + " to destination " + destination);
                JarUtils.jarDirectory((File)source, (File)destination);
            }
        } else {
            log.debug("Plugin is already in location " + source);
        }
    }

    public void uninstall(Artifact configId) throws NoSuchConfigException, IOException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        ConfigurationInfo configurationInfo = null;
        try {
            configurationInfo = this.loadConfigurationInfo(configId);
        }
        catch (IOException e) {
            // empty catch block
        }
        File location = this.repository.getLocation(configId);
        FileUtils.recursiveDelete((File)location);
        int dirDepth = 0;
        boolean m2repo = true;
        if (m2repo) {
            dirDepth = 3;
        }
        File temp = location;
        for (int i = 0; i < dirDepth && (temp = temp.getParentFile()).listFiles().length == 0; ++i) {
            temp.delete();
        }
        if (configurationInfo != null) {
            IOException ioException = null;
            for (Artifact ownedConfiguration : configurationInfo.getOwnedConfigurations()) {
                try {
                    this.uninstall(ownedConfiguration);
                }
                catch (NoSuchConfigException e) {
                }
                catch (IOException e) {
                    if (ioException == null) continue;
                    ioException = e;
                }
            }
            if (ioException != null) {
                throw ioException;
            }
        }
        this.transformer.remove(configId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationInfo> listConfigurations() {
        SortedSet artifacts = this.repository.list();
        ArrayList<ConfigurationInfo> configs = new ArrayList<ConfigurationInfo>();
        RepositoryConfigurationStore repositoryConfigurationStore = this;
        synchronized (repositoryConfigurationStore) {
            for (Artifact configId : artifacts) {
                try {
                    ConfigurationInfo configurationInfo = this.loadConfigurationInfo(configId);
                    configs.add(configurationInfo);
                }
                catch (NoSuchConfigException e) {
                }
                catch (IOException e) {
                    log.error("Unable to load ConfigurationInfo for " + configId, (Throwable)e);
                }
            }
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationInfo loadConfigurationInfo(Artifact configId) throws NoSuchConfigException, IOException {
        ConfigurationInfo configurationInfo;
        File location = this.repository.getLocation(configId);
        if (!location.exists() && !location.canRead()) {
            throw new NoSuchConfigException(configId);
        }
        File inPlaceLocation = this.inPlaceConfUtil.readInPlaceLocation(location);
        if (location.isDirectory()) {
            File infoFile = new File(location, "META-INF");
            if (!(infoFile = new File(infoFile, "config.info")).exists()) throw new NoSuchConfigException(configId);
            if (!infoFile.canRead()) {
                throw new NoSuchConfigException(configId);
            }
            FileInputStream in2 = new FileInputStream(infoFile);
            try {
                configurationInfo = ConfigurationUtil.readConfigurationInfo((InputStream)in2, (AbstractName)this.getAbstractName(), (File)inPlaceLocation);
                return configurationInfo;
            }
            finally {
                IOUtils.close((Closeable)in2);
            }
        }
        JarFile jarFile = new JarFile(location);
        InputStream in = null;
        try {
            ZipEntry entry = jarFile.getEntry("META-INF/config.info");
            if (entry == null) {
                throw new NoSuchConfigException(configId);
            }
            in = jarFile.getInputStream(entry);
            configurationInfo = ConfigurationUtil.readConfigurationInfo((InputStream)in, (AbstractName)this.getAbstractName(), (File)inPlaceLocation);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            JarUtils.close((JarFile)jarFile);
            throw throwable;
        }
        IOUtils.close((Closeable)in);
        JarUtils.close((JarFile)jarFile);
        return configurationInfo;
    }
}

