/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.system.resolver.LocalAliasedArtifactResolver;
import org.apache.geronimo.system.serverinfo.ServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitDefaultArtifactResolver
extends DefaultArtifactResolver
implements LocalAliasedArtifactResolver {
    private static final String COMMENT = "#You can use this file to indicate that you want to substitute one module for another.\n#format is oldartifactid=newartifactId e.g.\n#org.apache.geronimo.configs/transaction//car=org.apache.geronimo.configs/transaction-jta11/1.2-SNAPSHOT/car\n#versions can be ommitted on the left side but not the right.\n#This can also specify explicit versions in the same format.";
    private final String artifactAliasesFile;
    private final ServerInfo serverInfo;
    public static final GBeanInfo GBEAN_INFO;

    public ExplicitDefaultArtifactResolver(String versionMapLocation, ArtifactManager artifactManager, Collection<? extends ListableRepository> repositories, ServerInfo serverInfo) throws IOException {
        super(artifactManager, repositories, ExplicitDefaultArtifactResolver.buildExplicitResolution(versionMapLocation, serverInfo));
        this.artifactAliasesFile = versionMapLocation;
        this.serverInfo = serverInfo;
    }

    @Override
    public String getArtifactAliasesFile() {
        return this.artifactAliasesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Artifact, Artifact> buildExplicitResolution(String versionMapLocation, ServerInfo serverInfo) throws IOException {
        File location;
        if (versionMapLocation == null) {
            return null;
        }
        Properties properties = new Properties();
        File file = location = serverInfo == null ? new File(versionMapLocation) : serverInfo.resolveServer(versionMapLocation);
        if (location.exists()) {
            FileInputStream in = new FileInputStream(location);
            try {
                properties.load(in);
            }
            finally {
                in.close();
            }
        }
        return ExplicitDefaultArtifactResolver.propertiesToArtifactMap(properties);
    }

    private static Map<Artifact, Artifact> propertiesToArtifactMap(Properties properties) {
        HashMap<Artifact, Artifact> explicitResolution = new HashMap<Artifact, Artifact>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String resolvedString = (String)entry.getValue();
            Artifact source = Artifact.createPartial((String)key);
            Artifact resolved = Artifact.create((String)resolvedString);
            explicitResolution.put(source, resolved);
        }
        return explicitResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveExplicitResolution(Map<Artifact, Artifact> artifactMap, String versionMapLocation, ServerInfo serverInfo) throws IOException {
        File parent;
        File location;
        if (versionMapLocation == null) {
            return;
        }
        File file = location = serverInfo == null ? new File(versionMapLocation) : serverInfo.resolveServer(versionMapLocation);
        if (!(location.exists() || (parent = location.getParentFile()).exists() || parent.mkdirs())) {
            throw new IOException("Could not create directory for artifact aliases at " + parent);
        }
        FileOutputStream in = new FileOutputStream(location);
        Properties properties = ExplicitDefaultArtifactResolver.artifactMapToProperties(artifactMap);
        try {
            properties.store(in, COMMENT);
        }
        finally {
            in.close();
        }
    }

    private static Properties artifactMapToProperties(Map<Artifact, Artifact> artifactMap) {
        Properties properties = new Properties();
        for (Map.Entry<Artifact, Artifact> entry : artifactMap.entrySet()) {
            properties.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return properties;
    }

    @Override
    public synchronized void addAliases(Properties properties) throws IOException {
        Map<Artifact, Artifact> explicitResolutions = ExplicitDefaultArtifactResolver.propertiesToArtifactMap(properties);
        this.getExplicitResolution().putAll(explicitResolutions);
        ExplicitDefaultArtifactResolver.saveExplicitResolution(this.getExplicitResolution(), this.artifactAliasesFile, this.serverInfo);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ExplicitDefaultArtifactResolver.class, (String)"ArtifactResolver");
        infoFactory.addAttribute("versionMapLocation", String.class, true, true);
        infoFactory.addReference("ArtifactManager", ArtifactManager.class, "ArtifactManager");
        infoFactory.addReference("Repositories", ListableRepository.class, "Repository");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(ArtifactResolver.class);
        infoFactory.setConstructor(new String[]{"versionMapLocation", "ArtifactManager", "Repositories", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

