/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.geronimo.system.plugin.model.AttributeType;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.GbeanType;
import org.apache.geronimo.system.plugin.model.ModuleType;
import org.apache.geronimo.system.plugin.model.ObjectFactory;
import org.xml.sax.SAXException;

public class AttributesXmlUtil {
    public static final XMLInputFactory XMLINPUT_FACTORY = XMLInputFactory.newInstance();
    public static final JAXBContext ATTRIBUTES_CONTEXT;
    public static final JAXBContext ATTRIBUTE_CONTEXT;
    public static final JAXBContext MODULE_CONTEXT;
    public static final JAXBContext GBEAN_CONTEXT;

    public static void writeAttribute(AttributeType metadata, Writer out) throws XMLStreamException, JAXBException {
        Marshaller marshaller = ATTRIBUTE_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        JAXBElement<AttributeType> element = new ObjectFactory().createAttribute(metadata);
        marshaller.marshal(element, out);
    }

    public static String extractAttributeValue(AttributeType attr) throws JAXBException, XMLStreamException {
        StringWriter sw = new StringWriter();
        AttributesXmlUtil.writeAttribute(attr, sw);
        String s = sw.toString();
        int start = s.indexOf(62);
        start = s.indexOf(62, start + 1);
        int end = s.lastIndexOf(60);
        if (end < start) {
            return null;
        }
        return s.substring(start + 1, end).trim();
    }

    public static void writeAttributes(AttributesType metadata, Writer out) throws XMLStreamException, JAXBException {
        Marshaller marshaller = ATTRIBUTES_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        JAXBElement<AttributesType> element = new ObjectFactory().createAttributes(metadata);
        marshaller.marshal(element, out);
    }

    public static AttributesType loadAttributes(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = ATTRIBUTES_CONTEXT.createUnmarshaller();
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        JAXBElement element = unmarshaller.unmarshal(xmlStream, AttributesType.class);
        AttributesType pluginList = (AttributesType)element.getValue();
        return pluginList;
    }

    public static ModuleType loadModule(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = MODULE_CONTEXT.createUnmarshaller();
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        JAXBElement element = unmarshaller.unmarshal(xmlStream, ModuleType.class);
        ModuleType pluginList = (ModuleType)element.getValue();
        return pluginList;
    }

    public static GbeanType loadGbean(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = GBEAN_CONTEXT.createUnmarshaller();
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        JAXBElement element = unmarshaller.unmarshal(xmlStream, GbeanType.class);
        GbeanType pluginList = (GbeanType)element.getValue();
        return pluginList;
    }

    public static AttributeType loadAttribute(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = ATTRIBUTE_CONTEXT.createUnmarshaller();
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        JAXBElement element = unmarshaller.unmarshal(xmlStream, AttributeType.class);
        AttributeType attributeType = (AttributeType)element.getValue();
        return attributeType;
    }

    static {
        try {
            ATTRIBUTES_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{AttributesType.class});
            MODULE_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ModuleType.class});
            GBEAN_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{GbeanType.class});
            ATTRIBUTE_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{AttributeType.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create jaxb contexts for plugin types");
        }
    }
}

