/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.cli.daemon.DaemonCLParser;
import org.apache.geronimo.common.GeronimoEnvironment;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DebugLoggingLifecycleMonitor;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.LifecycleMonitor;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.Main;
import org.apache.geronimo.system.main.LongStartupMonitor;
import org.apache.geronimo.system.main.ServerStatus;
import org.apache.geronimo.system.main.SilentStartupMonitor;
import org.apache.geronimo.system.main.SimpleProgressBarStartupMonitor;
import org.apache.geronimo.system.main.StartupMonitor;
import org.apache.geronimo.system.serverinfo.DirectoryUtils;

public class EmbeddedDaemon
implements Main {
    private static final Log log = LogFactory.getLog(EmbeddedDaemon.class);
    protected final Kernel kernel;
    private StartupMonitor monitor;
    private LifecycleMonitor lifecycleMonitor;
    private List<Artifact> configs = new ArrayList<Artifact>();
    public static final GBeanInfo GBEAN_INFO;

    public EmbeddedDaemon(Kernel kernel) {
        this.kernel = kernel;
    }

    public int execute(Object opaque) {
        if (!(opaque instanceof DaemonCLParser)) {
            throw new IllegalArgumentException("Argument type is [" + opaque.getClass() + "]; expected [" + DaemonCLParser.class + "]");
        }
        DaemonCLParser parser = (DaemonCLParser)opaque;
        this.initializeMonitor(parser);
        this.initializeOverride(parser);
        long start = System.currentTimeMillis();
        System.out.println("Booting Geronimo Kernel (in Java " + System.getProperty("java.version") + ")...");
        System.out.flush();
        GeronimoEnvironment.init();
        this.monitor.systemStarting(start);
        return this.doStartup();
    }

    protected void initializeOverride(DaemonCLParser parser) {
        String[] override = parser.getOverride();
        if (null != override) {
            for (String anOverride : override) {
                this.configs.add(Artifact.create((String)anOverride));
            }
        }
    }

    protected void initializeMonitor(DaemonCLParser parser) {
        this.monitor = parser.isVerboseInfo() || parser.isVerboseDebug() || parser.isVerboseTrace() || parser.isNoProgress() ? new SilentStartupMonitor() : (parser.isLongProgress() ? new LongStartupMonitor() : new SimpleProgressBarStartupMonitor());
        this.lifecycleMonitor = new DebugLoggingLifecycleMonitor(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStartup() {
        try {
            Set configLists;
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null || !new File(tmpDir).exists() || !new File(tmpDir).isDirectory()) {
                System.err.println("The java.io.tmpdir system property specifies a non-existent directory: " + tmpDir);
                return 1;
            }
            File geronimoInstallDirectory = DirectoryUtils.getGeronimoInstallDirectory();
            if (geronimoInstallDirectory == null) {
                System.err.println("Could not determine geronimo installation directory");
                return 1;
            }
            int exitCode = this.initializeKernel();
            if (0 != exitCode) {
                return exitCode;
            }
            this.monitor.systemStarted(this.kernel);
            AbstractNameQuery query = new AbstractNameQuery(PersistentConfigurationList.class.getName());
            if (this.configs.isEmpty()) {
                configLists = this.kernel.listGBeans(query);
                for (AbstractName configListName : configLists) {
                    try {
                        this.configs.addAll((List)this.kernel.invoke(configListName, "restore"));
                    }
                    catch (IOException e) {
                        System.err.println("Unable to restore last known configurations");
                        e.printStackTrace();
                        this.shutdownKernel();
                        return 1;
                    }
                }
            }
            this.monitor.foundModules(this.configs.toArray(new Artifact[this.configs.size()]));
            try {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
                try {
                    int unloadedConfigsCount;
                    ArrayList<Artifact> unloadedConfigs = new ArrayList<Artifact>(this.configs);
                    do {
                        unloadedConfigsCount = unloadedConfigs.size();
                        LinkedHashSet sorted = configurationManager.sort(unloadedConfigs, this.lifecycleMonitor);
                        for (Artifact configID : sorted) {
                            this.monitor.moduleLoading(configID);
                            configurationManager.loadConfiguration(configID, this.lifecycleMonitor);
                            this.monitor.moduleLoaded(configID);
                            this.monitor.moduleStarting(configID);
                            configurationManager.startConfiguration(configID, this.lifecycleMonitor);
                            this.monitor.moduleStarted(configID);
                        }
                    } while (unloadedConfigsCount > unloadedConfigs.size());
                    if (!unloadedConfigs.isEmpty()) {
                        throw new InvalidConfigException("Could not locate configs to start: " + unloadedConfigs);
                    }
                    AbstractNameQuery startedQuery = new AbstractNameQuery(ServerStatus.class.getName());
                    Set statusBeans = this.kernel.listGBeans(startedQuery);
                    for (AbstractName statusName : statusBeans) {
                        ServerStatus status = (ServerStatus)this.kernel.getGBean(statusName);
                        if (status == null) continue;
                        status.setServerStarted(true);
                    }
                }
                finally {
                    ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
                }
            }
            catch (Exception e) {
                this.monitor.serverStartFailed(e);
                this.shutdownKernel();
                return 1;
            }
            configLists = this.kernel.listGBeans(query);
            for (AbstractName configListName : configLists) {
                this.kernel.setAttribute(configListName, "kernelFullyStarted", (Object)Boolean.TRUE);
            }
            this.monitor.startupFinished();
            this.monitor = null;
            while (this.kernel.isRunning()) {
                try {
                    Kernel i$ = this.kernel;
                    synchronized (i$) {
                        this.kernel.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (Exception e) {
            if (this.monitor != null) {
                this.monitor.serverStartFailed(e);
            }
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    protected void shutdownKernel() {
        try {
            this.kernel.shutdown();
        }
        catch (Exception e1) {
            System.err.println("Exception caught during kernel shutdown");
            e1.printStackTrace();
        }
    }

    protected int initializeKernel() throws Exception {
        return 0;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(EmbeddedDaemon.class, (String)"EmbeddedDaemon");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

