/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.AttributesXmlUtil;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.system.configuration.condition.JexlExpressionParser;
import org.apache.geronimo.system.plugin.model.AttributeType;
import org.apache.geronimo.system.plugin.model.GbeanType;
import org.apache.geronimo.system.plugin.model.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GBeanOverride
implements Serializable {
    private static final Log log = LogFactory.getLog(GBeanOverride.class);
    public static final String ATTRIBUTE_NAMESPACE = "http://geronimo.apache.org/xml/ns/attributes-1.2";
    private final Object name;
    private String comment;
    private boolean load;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Map<String, String> propertyEditors = new HashMap<String, String>();
    private final Map<String, ReferencePatterns> references = new LinkedHashMap<String, ReferencePatterns>();
    private final Set<String> clearAttributes = new LinkedHashSet<String>();
    private final Set<String> nullAttributes = new LinkedHashSet<String>();
    private final Set<String> clearReferences = new LinkedHashSet<String>();
    private final String gbeanInfo;
    private final JexlExpressionParser expressionParser;

    public GBeanOverride(String name, boolean load, JexlExpressionParser expressionParser) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
        this.expressionParser = expressionParser;
    }

    public GBeanOverride(AbstractName name, boolean load, JexlExpressionParser expressionParser) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
        this.expressionParser = expressionParser;
    }

    public GBeanOverride(GBeanOverride original, String oldArtifact, String newArtifact) {
        Object name = original.name;
        if (name instanceof String) {
            name = GBeanOverride.replace((String)name, oldArtifact, newArtifact);
        } else if (name instanceof AbstractName) {
            String value = name.toString();
            value = GBeanOverride.replace(value, oldArtifact, newArtifact);
            name = new AbstractName(URI.create(value));
        }
        this.name = name;
        this.load = original.load;
        this.comment = original.getComment();
        this.attributes.putAll(original.attributes);
        this.propertyEditors.putAll(original.propertyEditors);
        this.references.putAll(original.references);
        this.clearAttributes.addAll(original.clearAttributes);
        this.nullAttributes.addAll(original.nullAttributes);
        this.clearReferences.addAll(original.clearReferences);
        this.gbeanInfo = original.gbeanInfo;
        this.expressionParser = original.expressionParser;
    }

    private static String replace(String original, String oldArtifact, String newArtifact) {
        int pos = original.indexOf(oldArtifact);
        if (pos == -1) {
            return original;
        }
        int last = -1;
        StringBuffer buf = new StringBuffer();
        while (pos > -1) {
            buf.append(original.substring(last + 1, pos));
            buf.append(newArtifact);
            last = pos + oldArtifact.length() - 1;
            pos = original.indexOf(oldArtifact, last);
        }
        buf.append(original.substring(last + 1));
        return buf.toString();
    }

    public GBeanOverride(GBeanData gbeanData, JexlExpressionParser expressionParser, ClassLoader classLoader) throws InvalidAttributeException {
        GBeanInfo gbeanInfo = gbeanData.getGBeanInfo();
        this.gbeanInfo = gbeanInfo.getSourceClass();
        if (this.gbeanInfo == null) {
            throw new IllegalArgumentException("GBeanInfo must have a source class set");
        }
        this.name = gbeanData.getAbstractName();
        this.load = true;
        for (Map.Entry o : gbeanData.getAttributes().entrySet()) {
            Map.Entry entry = o;
            String attributeName = (String)entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidAttributeException("No attribute: " + attributeName + " for gbean: " + gbeanData.getAbstractName());
            }
            Object attributeValue = entry.getValue();
            this.setAttribute(attributeName, attributeValue, attributeInfo.getType(), classLoader);
        }
        this.references.putAll(gbeanData.getReferences());
        this.expressionParser = expressionParser;
    }

    public GBeanOverride(GbeanType gbean, JexlExpressionParser expressionParser) throws InvalidGBeanException {
        String nameString = gbean.getName();
        this.name = nameString.indexOf(63) > -1 ? new AbstractName(URI.create(nameString)) : nameString;
        String gbeanInfoString = gbean.getGbeanInfo();
        this.gbeanInfo = gbeanInfoString != null && gbeanInfoString.length() > 0 ? gbeanInfoString : null;
        if (this.gbeanInfo != null && !(this.name instanceof AbstractName)) {
            throw new InvalidGBeanException("A gbean element using the gbeanInfo attribute must be specified using a full AbstractName: name=" + nameString);
        }
        this.load = gbean.isLoad();
        this.comment = gbean.getComment();
        for (Object o : gbean.getAttributeOrReference()) {
            if (o instanceof AttributeType) {
                String value;
                AttributeType attr = (AttributeType)o;
                String propertyEditor = attr.getPropertyEditor();
                if (null != propertyEditor) {
                    this.propertyEditors.put(attr.getName(), propertyEditor);
                }
                if (attr.isNull()) {
                    this.setNullAttribute(attr.getName());
                    continue;
                }
                try {
                    value = AttributesXmlUtil.extractAttributeValue(attr);
                }
                catch (JAXBException e) {
                    throw new InvalidGBeanException("Could not extract attribute value from gbean override", (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new InvalidGBeanException("Could not extract attribute value from gbean override", (Throwable)e);
                }
                if (value == null || value.length() == 0) {
                    this.setClearAttribute(attr.getName());
                    continue;
                }
                String truevalue = (String)((Object)EncryptionManager.decrypt((String)value));
                this.setAttribute(attr.getName(), truevalue);
                continue;
            }
            if (!(o instanceof ReferenceType)) continue;
            ReferenceType ref = (ReferenceType)o;
            if (ref.getPattern().isEmpty()) {
                this.setClearReference(ref.getName());
                continue;
            }
            HashSet<AbstractNameQuery> patternSet = new HashSet<AbstractNameQuery>();
            for (ReferenceType.Pattern pattern : ref.getPattern()) {
                String groupId = pattern.getGroupId();
                String artifactId = pattern.getArtifactId();
                String version = pattern.getVersion();
                String type = pattern.getType();
                String module = pattern.getModule();
                String name = pattern.getName();
                Artifact referenceArtifact = null;
                if (artifactId != null) {
                    referenceArtifact = new Artifact(groupId, artifactId, version, type);
                }
                HashMap<String, String> nameMap = new HashMap<String, String>();
                if (module != null) {
                    nameMap.put("module", module);
                }
                if (name != null) {
                    nameMap.put("name", name);
                }
                AbstractNameQuery abstractNameQuery = new AbstractNameQuery(referenceArtifact, nameMap, Collections.EMPTY_SET);
                patternSet.add(abstractNameQuery);
            }
            ReferencePatterns patterns = new ReferencePatterns(patternSet);
            this.setReferencePatterns(ref.getName(), patterns);
        }
        this.expressionParser = expressionParser;
    }

    public Object getName() {
        return this.name;
    }

    public String getGBeanInfo() {
        return this.gbeanInfo;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Set<String> getClearAttributes() {
        return this.clearAttributes;
    }

    public Set<String> getNullAttributes() {
        return this.nullAttributes;
    }

    public boolean isNullAttribute(String attributeName) {
        return this.nullAttributes.contains(attributeName);
    }

    public boolean isClearAttribute(String attributeName) {
        return this.clearAttributes.contains(attributeName);
    }

    public Set<String> getClearReferences() {
        return this.clearReferences;
    }

    public boolean isClearReference(String referenceName) {
        return this.clearReferences.contains(referenceName);
    }

    public void setClearAttribute(String attributeName) {
        this.clearAttributes.add(attributeName);
        this.nullAttributes.remove(attributeName);
        this.attributes.remove(attributeName);
    }

    public void setNullAttribute(String attributeName) {
        this.nullAttributes.add(attributeName);
        this.clearAttributes.remove(attributeName);
        this.attributes.remove(attributeName);
    }

    public void setClearReference(String referenceName) {
        this.clearReferences.add(referenceName);
        this.references.remove(referenceName);
    }

    public void setAttribute(String attributeName, Object attributeValue, String attributeType, ClassLoader classLoader) throws InvalidAttributeException {
        String stringValue = this.getAsText(attributeName, attributeValue, attributeType, classLoader);
        this.setAttribute(attributeName, stringValue);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        if (attributeValue == null || attributeValue.length() == 0) {
            this.setClearAttribute(attributeName);
        } else {
            this.attributes.put(attributeName, attributeValue);
            this.clearAttributes.remove(attributeName);
            this.nullAttributes.remove(attributeName);
        }
    }

    public Map<String, ReferencePatterns> getReferences() {
        return this.references;
    }

    public ReferencePatterns getReferencePatterns(String name) {
        return this.references.get(name);
    }

    public void setReferencePatterns(String name, ReferencePatterns patterns) {
        this.references.put(name, patterns);
        this.clearReferences.remove(name);
    }

    public boolean applyOverrides(GBeanData data, Artifact configName, AbstractName gbeanName, ClassLoader classLoader) throws InvalidConfigException {
        if (!this.isLoad()) {
            return false;
        }
        GBeanInfo gbeanInfo = data.getGBeanInfo();
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            String attributeName = entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidConfigException("No attribute: " + attributeName + " for gbean: " + data.getAbstractName());
            }
            String valueString = entry.getValue();
            Object value = this.getValue(attributeInfo, valueString, configName, gbeanName, classLoader);
            data.setAttribute(attributeName, value);
        }
        for (String string : this.getClearAttributes()) {
            data.clearAttribute(string);
        }
        for (String string : this.getNullAttributes()) {
            data.setAttribute(string, null);
        }
        for (Map.Entry entry : this.getReferences().entrySet()) {
            String referenceName = (String)entry.getKey();
            GReferenceInfo referenceInfo = gbeanInfo.getReference(referenceName);
            if (referenceInfo == null) {
                throw new InvalidConfigException("No reference: " + referenceName + " for gbean: " + data.getAbstractName());
            }
            ReferencePatterns referencePatterns = (ReferencePatterns)entry.getValue();
            data.setReferencePatterns(referenceName, referencePatterns);
        }
        for (String string : this.getClearReferences()) {
            data.clearReference(string);
        }
        return true;
    }

    private synchronized Object getValue(GAttributeInfo attribute, String value, Artifact configurationName, AbstractName gbeanName, ClassLoader classLoader) {
        if (value == null) {
            return null;
        }
        value = this.substituteVariables(attribute.getName(), value);
        PropertyEditor editor = this.loadPropertyEditor(attribute, classLoader);
        editor.setAsText(value);
        log.debug((Object)("Setting value for " + configurationName + "/" + gbeanName + "/" + attribute.getName() + " to value " + value));
        return editor.getValue();
    }

    protected PropertyEditor loadPropertyEditor(GAttributeInfo attribute, ClassLoader classLoader) {
        String propertyEditor = this.propertyEditors.get(attribute.getName());
        if (null == propertyEditor) {
            PropertyEditor editor;
            try {
                editor = PropertyEditors.findEditor((String)attribute.getType(), (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to load property editor for attribute type: " + attribute.getType());
            }
            if (editor == null) {
                throw new IllegalStateException("Unable to parse attribute of type " + attribute.getType() + "; no editor found");
            }
            return editor;
        }
        try {
            Class<?> propertyEditorClass = classLoader.loadClass(propertyEditor);
            return (PropertyEditor)propertyEditorClass.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot load property editor [" + propertyEditor + "]", ex);
        }
    }

    public String substituteVariables(String attributeName, String input) {
        if (this.expressionParser != null) {
            return this.expressionParser.parse(input);
        }
        return input;
    }

    public GbeanType writeXml() {
        AttributeType attribute;
        String name;
        GbeanType gbean = new GbeanType();
        String gbeanName = this.name instanceof String ? (String)this.name : this.name.toString();
        gbean.setName(gbeanName);
        if (this.gbeanInfo != null) {
            gbean.setGbeanInfo(this.gbeanInfo);
        }
        if (!this.load) {
            gbean.setLoad(false);
        }
        if (this.comment != null) {
            gbean.setComment(this.comment);
        }
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            name = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                this.nullAttributes.add(name);
                this.clearAttributes.remove(name);
                continue;
            }
            this.nullAttributes.remove(name);
            this.clearAttributes.remove(name);
            if (name.toLowerCase().indexOf("password") > -1) {
                value = EncryptionManager.encrypt((Serializable)((Object)value));
            }
            value = "<attribute xmlns='http://geronimo.apache.org/xml/ns/attributes-1.2'>" + value.replaceAll("&(?!amp;)", "&amp;") + "</attribute>";
            StringReader reader = new StringReader(value);
            try {
                AttributeType attribute2 = AttributesXmlUtil.loadAttribute(reader);
                attribute2.setName(name);
                String editorClass = this.propertyEditors.get(name);
                if (null != editorClass) {
                    attribute2.setPropertyEditor(editorClass);
                }
                gbean.getAttributeOrReference().add(attribute2);
            }
            catch (Exception e) {
                log.error((Object)("Could not serialize attribute " + name + " in gbean " + gbeanName + ", value: " + value), (Throwable)e);
            }
        }
        for (String string : this.clearAttributes) {
            attribute = new AttributeType();
            attribute.setName(string);
            gbean.getAttributeOrReference().add(attribute);
        }
        for (String string : this.nullAttributes) {
            attribute = new AttributeType();
            attribute.setName(string);
            attribute.setNull(true);
            gbean.getAttributeOrReference().add(attribute);
        }
        for (Map.Entry entry : this.references.entrySet()) {
            name = (String)entry.getKey();
            ReferencePatterns patterns = (ReferencePatterns)entry.getValue();
            ReferenceType reference = new ReferenceType();
            reference.setName(name);
            Set<AbstractNameQuery> patternSet = patterns.isResolved() ? Collections.singleton(new AbstractNameQuery(patterns.getAbstractName())) : patterns.getPatterns();
            for (AbstractNameQuery pattern : patternSet) {
                Map nameMap;
                ReferenceType.Pattern patternType = new ReferenceType.Pattern();
                Artifact artifact = pattern.getArtifact();
                if (artifact != null) {
                    if (artifact.getGroupId() != null) {
                        patternType.setGroupId(artifact.getGroupId());
                    }
                    if (artifact.getArtifactId() != null) {
                        patternType.setArtifactId(artifact.getArtifactId());
                    }
                    if (artifact.getVersion() != null) {
                        patternType.setVersion(artifact.getVersion().toString());
                    }
                    if (artifact.getType() != null) {
                        patternType.setType(artifact.getType());
                    }
                }
                if ((nameMap = pattern.getName()).get("module") != null) {
                    patternType.setModule((String)nameMap.get("module"));
                }
                if (nameMap.get("name") != null) {
                    patternType.setName((String)nameMap.get("name"));
                }
                reference.getPattern().add(patternType);
            }
            gbean.getAttributeOrReference().add(reference);
        }
        for (String string : this.clearReferences) {
            ReferenceType reference = new ReferenceType();
            reference.setName(string);
            gbean.getAttributeOrReference().add(reference);
        }
        return gbean;
    }

    protected String getAsText(String attributeName, Object value, String type, ClassLoader classLoader) throws InvalidAttributeException {
        try {
            if (null == value || value instanceof String) {
                return (String)value;
            }
            Class typeClass = ClassLoading.loadClass((String)type, (ClassLoader)classLoader);
            PropertyEditor editor = PropertyEditors.findEditor(value.getClass());
            if (null == editor && null == (editor = PropertyEditors.findEditor((Class)typeClass))) {
                throw new InvalidAttributeException("Unable to format attribute of type " + type + "; no editor found");
            }
            if (!(type.equals(value.getClass().getName()) || typeClass.isPrimitive() || Collection.class.isAssignableFrom(typeClass))) {
                this.propertyEditors.put(attributeName, editor.getClass().getName());
            }
            editor.setValue(value);
            return editor.getAsText();
        }
        catch (ClassNotFoundException e) {
            throw (InvalidAttributeException)new InvalidAttributeException("Unable to store attribute type " + type).initCause(e);
        }
    }
}

