/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.log4j.PropertyConfigurator;

public class ApplicationLog4jConfigurationGBean {
    private static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    private static final String CATEGORY_PREFIX = "log4j.category.";
    private static final String LOGGER_PREFIX = "log4j.logger.";
    private static final String APPENDER_PREFIX = "log4j.appender.";
    private static final String RENDERER_PREFIX = "log4j.renderer.";
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationLog4jConfigurationGBean(String log4jResource, String log4jFile, ServerInfo serverInfo, ClassLoader classloader) throws IOException {
        InputStream in;
        if (log4jFile != null) {
            File file = serverInfo.resolveServer(log4jFile);
            in = new FileInputStream(file);
        } else if (log4jResource != null) {
            in = classloader.getResourceAsStream(log4jResource);
            if (in == null) {
                throw new NullPointerException("No log4j properties resource found at " + log4jResource);
            }
        } else {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.startsWith(CATEGORY_PREFIX) || key.startsWith(LOGGER_PREFIX) || key.startsWith(ADDITIVITY_PREFIX) || key.startsWith(APPENDER_PREFIX) || key.startsWith(RENDERER_PREFIX)) continue;
            it.remove();
        }
        PropertyConfigurator.configure((Properties)props);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ApplicationLog4jConfigurationGBean.class, (String)"SystemLog");
        infoBuilder.setPriority(2);
        infoBuilder.addAttribute("log4jResource", String.class, true);
        infoBuilder.addAttribute("log4jFile", String.class, true);
        infoBuilder.addAttribute("classloader", ClassLoader.class, false);
        infoBuilder.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoBuilder.setConstructor(new String[]{"log4jResource", "log4jFile", "ServerInfo", "classloader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

