/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.PooledSender;
import org.apache.catalina.tribes.transport.nio.ParallelNioSender;

public class PooledParallelSender
extends PooledSender {
    protected boolean connected = true;

    public void sendMessage(Member[] destination, ChannelMessage message) throws ChannelException {
        if (!this.connected) {
            throw new ChannelException("Sender not connected.");
        }
        ParallelNioSender sender = (ParallelNioSender)this.getSender();
        if (sender == null) {
            ChannelException cx = new ChannelException("Unable to retrieve a data sender, time out error.");
            for (int i = 0; i < destination.length; ++i) {
                cx.addFaultyMember(destination[i], new NullPointerException("Unable to retrieve a sender from the sender pool"));
            }
            throw cx;
        }
        try {
            sender.sendMessage(destination, message);
            sender.keepalive();
        }
        catch (ChannelException x) {
            sender.disconnect();
            throw x;
        }
        finally {
            this.returnSender(sender);
            if (!this.connected) {
                this.disconnect();
            }
        }
    }

    public DataSender getNewDataSender() {
        try {
            ParallelNioSender sender = new ParallelNioSender();
            AbstractSender.transferProperties(this, sender);
            return sender;
        }
        catch (IOException x) {
            throw new RuntimeException("Unable to open NIO selector.", x);
        }
    }

    public synchronized void disconnect() {
        this.connected = false;
        super.disconnect();
    }

    public synchronized void connect() throws IOException {
        this.connected = true;
        super.connect();
    }
}

