/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.docker;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

final class InternalConfig {
    private static final InternalConfig CONFIG = new InternalConfig();
    private final Map<String, String> config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalConfig() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(InternalConfig.class.getClassLoader());
        try {
            Properties properties = this.loadInternalProperties();
            this.config = properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty));
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static String get(String key, String defaultValue) {
        return Optional.ofNullable(InternalConfig.CONFIG.config.get(key)).orElseGet(() -> System.getProperty(key, defaultValue));
    }

    private Properties loadInternalProperties() {
        Properties properties = new Properties();
        ClassLoader loader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
        InputStream stream = loader.getResourceAsStream("META-INF/geronimo/microprofile/extensions/config/docker/configuration.properties");
        if (stream != null) {
            try {
                properties.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

