/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.docker;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.extensions.config.docker.BaseConfigSource;
import org.apache.geronimo.microprofile.extensions.config.docker.InternalConfig;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DockerConfigConfigSource
extends BaseConfigSource
implements ConfigSource {
    public DockerConfigConfigSource() {
        this(InternalConfig.get(DockerConfigConfigSource.class.getName() + ".base", "/"), Integer.parseInt(InternalConfig.get(DockerConfigConfigSource.class.getName() + ".ordinal", "100")), (String[])Stream.of(InternalConfig.get(DockerConfigConfigSource.class.getName() + ".prefixes", "").split(",")).map(String::trim).filter(it -> !it.isEmpty()).toArray(String[]::new));
    }

    public DockerConfigConfigSource(String base, int ordinal, String ... prefixes) {
        super(() -> DockerConfigConfigSource.reload(base, prefixes), ordinal);
    }

    public String getName() {
        return "docker-configs";
    }

    private static Map<String, String> reload(String base, String ... prefixes) {
        Path from = Paths.get(base, new String[0]);
        if (!Files.exists(from, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        Predicate<Path> matches = prefixes.length == 0 ? path -> !Files.isDirectory(path, new LinkOption[0]) && Stream.of(".xml", ".properties", ".yml", ".yaml", ".so", ".json", ".old", ".img", "vmlinuz", "core").noneMatch(ext -> path.getFileName().toString().endsWith((String)ext)) : path -> Stream.of(prefixes).anyMatch(prefix -> path.getFileName().toString().startsWith((String)prefix));
        try {
            return Files.list(from).filter(matches).map(path -> new AbstractMap.SimpleEntry<String, String>(path.getFileName().toString(), DockerConfigConfigSource.read(path))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    private static String read(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }
}

