/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.docker;

import java.io.IOException;
import java.io.StringReader;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.geronimo.microprofile.extensions.config.docker.InternalConfig;
import org.eclipse.microprofile.config.spi.ConfigSource;

abstract class BaseConfigSource
implements ConfigSource {
    private final Supplier<Map<String, String>> loader;
    private final int ordinal;
    private final Clock clock = Clock.systemUTC();
    private final long updateInterval;
    private final Map<String, String> mapping;
    private volatile Map<String, String> entries;
    private volatile long lastUpdate = -1L;

    BaseConfigSource(Supplier<Map<String, String>> loader, int ordinal) {
        this.loader = loader;
        this.ordinal = ordinal;
        this.updateInterval = Long.parseLong(InternalConfig.get(this.getClass().getName() + ".updateInterval", "10000"));
        this.mapping = this.asMap(InternalConfig.get(this.getClass().getName() + ".keyMapping", ""));
        this.doLoad();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Map<String, String> getProperties() {
        this.reloadIfNeeded();
        return new HashMap<String, String>(this.entries);
    }

    public String getValue(String propertyName) {
        this.reloadIfNeeded();
        return this.entries.get(propertyName);
    }

    private Map<String, String> asMap(String props) {
        Properties properties = new Properties();
        try (StringReader reader = new StringReader(props);){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty));
    }

    private void doLoad() {
        this.lastUpdate = this.clock.millis();
        Map<String, String> entries = this.loader.get();
        this.entries = this.mapping.isEmpty() ? entries : entries.entrySet().stream().collect(Collectors.toMap(it -> this.mapping.getOrDefault(it.getKey(), (String)it.getKey()), Map.Entry::getValue));
    }

    private void reloadIfNeeded() {
        if (this.clock.millis() - this.lastUpdate > this.updateInterval) {
            long start = this.clock.millis();
            this.doLoad();
            long end = this.clock.millis();
            long duration = end - start;
            if (duration > this.updateInterval) {
                Logger.getLogger(this.getClass().getName()).warning(() -> "Reloading the configuration took more than expected: " + duration + "ms");
            }
        }
    }
}

