/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.daytrader.ejb3;

import java.util.Date;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.geronimo.samples.daytrader.core.TradeServices;
import org.apache.geronimo.samples.daytrader.core.direct.TradeJEEDirect;
import org.apache.geronimo.samples.daytrader.ejb3.TradeSLSBLocal;
import org.apache.geronimo.samples.daytrader.util.Log;
import org.apache.geronimo.samples.daytrader.util.MDBStats;
import org.apache.geronimo.samples.daytrader.util.TimerStat;

@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="TradeBrokerQueue"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="NonDurable")})
public class DTBroker3MDB
implements MessageListener {
    private MDBStats mdbStats;
    private int statInterval = 100;
    @EJB
    private TradeSLSBLocal tradeSLSB;
    @Resource
    public MessageDrivenContext mdc;

    public DTBroker3MDB() {
        if (Log.doTrace()) {
            Log.trace((String)"DTBroker3MDB:DTBroker3MDB()");
        }
        if (this.statInterval <= 0) {
            this.statInterval = 100;
        }
        this.mdbStats = MDBStats.getInstance();
    }

    public void onMessage(Message message) {
        block14: {
            try {
                if (Log.doTrace()) {
                    Log.trace((String)("TradeBroker:onMessage -- received message -->" + ((TextMessage)message).getText() + "command-->" + message.getStringProperty("command") + "<--"));
                }
                if (message.getJMSRedelivered()) {
                    Log.log((String)("DTBroker3MDB: The following JMS message was redelivered due to a rollback:\n" + ((TextMessage)message).getText()));
                    return;
                }
                String command = message.getStringProperty("command");
                if (command == null) {
                    Log.debug((String)("DTBroker3MDB:onMessage -- received message with null command. Message-->" + message));
                    return;
                }
                if (command.equalsIgnoreCase("neworder")) {
                    Integer orderID = new Integer(message.getIntProperty("orderID"));
                    boolean twoPhase = message.getBooleanProperty("twoPhase");
                    boolean direct = message.getBooleanProperty("direct");
                    long publishTime = message.getLongProperty("publishTime");
                    long receiveTime = System.currentTimeMillis();
                    TradeServices trade = null;
                    try {
                        trade = this.getTrade(direct);
                        if (Log.doTrace()) {
                            Log.trace((String)("DTBroker3MDB:onMessage - completing order " + orderID + " twoPhase=" + twoPhase + " direct=" + direct));
                        }
                        trade.completeOrder(orderID, twoPhase);
                        TimerStat currentStats = this.mdbStats.addTiming("DTBroker3MDB:neworder", publishTime, receiveTime);
                        if (currentStats.getCount() % this.statInterval == 0) {
                            Log.log((String)(new Date() + "\nDTBroker3MDB: processed 100 stock trading orders. " + "\nCurrent NewOrder Message Statistics\n\tTotal NewOrders process = " + currentStats.getCount() + "\n\tTime to receive messages (in seconds):" + "\n\t\tmin: " + currentStats.getMinSecs() + "\n\t\tmax: " + currentStats.getMaxSecs() + "\n\t\tavg: " + currentStats.getAvgSecs() + "\n\n\n\tThe current order being processed is:\n\t" + ((TextMessage)message).getText()));
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        Log.error((String)("DTBroker3MDB:onMessage Exception completing order: " + orderID + "\n"), (Throwable)e);
                        this.mdc.setRollbackOnly();
                    }
                    break block14;
                }
                if (command.equalsIgnoreCase("ping")) {
                    long receiveTime;
                    long publishTime;
                    TimerStat currentStats;
                    if (Log.doTrace()) {
                        Log.trace((String)("DTBroker3MDB:onMessage  received test command -- message: " + ((TextMessage)message).getText()));
                    }
                    if ((currentStats = this.mdbStats.addTiming("DTBroker3MDB:ping", publishTime = message.getLongProperty("publishTime"), receiveTime = System.currentTimeMillis())).getCount() % this.statInterval == 0) {
                        Log.log((String)(new Date() + "\nDTBroker3MDB: received 100 ping messages. " + "\nCurrent Ping Message Statistics\n\tTotal ping message count = " + currentStats.getCount() + "\n\tTime to receive messages (in seconds):" + "\n\t\tmin: " + currentStats.getMinSecs() + "\n\t\tmax: " + currentStats.getMaxSecs() + "\n\t\tavg: " + currentStats.getAvgSecs() + "\n\n\n\tThe current message is:\n\t" + ((TextMessage)message).getText()));
                    }
                } else {
                    Log.error((String)("DTBroker3MDB:onMessage - unknown message request command-->" + command + "<-- message=" + ((TextMessage)message).getText()));
                }
            }
            catch (Throwable t) {
                Log.error((String)"DTBroker3MDB: Error rolling back transaction", (Throwable)t);
                this.mdc.setRollbackOnly();
            }
        }
    }

    private TradeServices getTrade(boolean direct) throws Exception {
        TradeSLSBLocal trade = direct ? new TradeJEEDirect() : this.tradeSLSB;
        return trade;
    }
}

