/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.property;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class SetPropertyMojo
extends AbstractLogEnabled
implements Mojo {
    private Log log;
    protected String propertyName;
    protected String propertyValuePrefix;
    protected boolean listFiles;
    protected Dependency[] classpath;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        if (this.classpath != null && this.classpath.length > 0) {
            if (this.propertyValuePrefix != null) {
                buffer.append(this.propertyValuePrefix);
            }
            for (int i = 0; i < this.classpath.length; ++i) {
                Dependency dependency = this.classpath[i];
                Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), null, dependency.getType());
                String path = this.localRepository.pathOf(artifact);
                File file = new File(this.localRepository.getBasedir(), path);
                if (!file.exists()) {
                    this.getLog().warn((CharSequence)("File " + file + " does not exist"));
                }
                if (this.listFiles) {
                    buffer.append(file.getAbsolutePath());
                } else {
                    buffer.append(file.getParentFile().getAbsolutePath());
                }
                if (i + 1 >= this.classpath.length) continue;
                buffer.append(File.pathSeparator);
            }
        }
        this.getLog().debug((CharSequence)("Setting " + this.propertyName + " property to " + buffer));
        this.project.getProperties().put(this.propertyName, buffer.toString());
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.setLog((Log)new SystemStreamLog());
        }
        return this.log;
    }
}

