/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.blueprint.ComponentDefinitionRegistry;
import org.apache.geronimo.blueprint.ExtendedBeanMetadata;
import org.apache.geronimo.blueprint.ExtendedBlueprintContainer;
import org.apache.geronimo.blueprint.container.AbstractServiceReferenceRecipe;
import org.apache.geronimo.blueprint.container.BeanRecipe;
import org.apache.geronimo.blueprint.container.BlueprintRepository;
import org.apache.geronimo.blueprint.container.ReferenceListRecipe;
import org.apache.geronimo.blueprint.container.ReferenceRecipe;
import org.apache.geronimo.blueprint.container.ServiceListener;
import org.apache.geronimo.blueprint.container.ServiceRecipe;
import org.apache.geronimo.blueprint.di.ArrayRecipe;
import org.apache.geronimo.blueprint.di.CollectionRecipe;
import org.apache.geronimo.blueprint.di.EnvironmentRecipe;
import org.apache.geronimo.blueprint.di.IdRefRecipe;
import org.apache.geronimo.blueprint.di.MapRecipe;
import org.apache.geronimo.blueprint.di.Recipe;
import org.apache.geronimo.blueprint.di.RefRecipe;
import org.apache.geronimo.blueprint.di.ValueRecipe;
import org.apache.geronimo.blueprint.mutable.MutableMapMetadata;
import org.apache.geronimo.blueprint.reflect.EnvironmentMetadataImpl;
import org.apache.geronimo.blueprint.reflect.MetadataUtil;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;

public class RecipeBuilder {
    private Set<String> names = new HashSet<String>();
    private int nameCounter;
    private ExtendedBlueprintContainer blueprintContainer;
    private ComponentDefinitionRegistry registry;

    public RecipeBuilder(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
        this.registry = blueprintContainer.getComponentDefinitionRegistry();
    }

    public BlueprintRepository createRepository() {
        BlueprintRepository repository = new BlueprintRepository(this.blueprintContainer);
        for (String name : this.registry.getComponentDefinitionNames()) {
            ComponentMetadata component = this.registry.getComponentDefinition(name);
            Recipe recipe = this.createRecipe(component);
            repository.putRecipe(recipe.getName(), recipe);
        }
        repository.validate();
        return repository;
    }

    public Recipe createRecipe(ComponentMetadata component) {
        if (component instanceof BeanMetadata) {
            return this.createBeanRecipe((BeanMetadata)component);
        }
        if (component instanceof ServiceMetadata) {
            return this.createServiceRecipe((ServiceMetadata)component);
        }
        if (component instanceof ReferenceMetadata) {
            return this.createReferenceRecipe((ReferenceMetadata)component);
        }
        if (component instanceof ReferenceListMetadata) {
            return this.createReferenceListRecipe((ReferenceListMetadata)component);
        }
        if (component instanceof EnvironmentMetadataImpl) {
            return this.createEnvironmentRecipe((EnvironmentMetadataImpl)component);
        }
        throw new IllegalStateException("Unsupported component type " + component.getClass());
    }

    private Recipe createEnvironmentRecipe(EnvironmentMetadataImpl environmentMetadata) {
        return new EnvironmentRecipe(environmentMetadata.getId(), environmentMetadata.getObject());
    }

    private Recipe createReferenceListRecipe(ReferenceListMetadata metadata) {
        CollectionRecipe listenersRecipe = null;
        if (metadata.getReferenceListeners() != null) {
            listenersRecipe = new CollectionRecipe(this.getName(null), ArrayList.class);
            for (ReferenceListener listener : metadata.getReferenceListeners()) {
                listenersRecipe.add(this.createRecipe(listener));
            }
        }
        ArrayList<Recipe> deps = new ArrayList<Recipe>();
        for (String name : metadata.getDependsOn()) {
            deps.add(new RefRecipe(this.getName(null), name));
        }
        ReferenceListRecipe recipe = new ReferenceListRecipe(this.getName(metadata.getId()), this.blueprintContainer, metadata, listenersRecipe, deps);
        return recipe;
    }

    private ReferenceRecipe createReferenceRecipe(ReferenceMetadata metadata) {
        CollectionRecipe listenersRecipe = null;
        if (metadata.getReferenceListeners() != null) {
            listenersRecipe = new CollectionRecipe(this.getName(null), ArrayList.class);
            for (ReferenceListener listener : metadata.getReferenceListeners()) {
                listenersRecipe.add(this.createRecipe(listener));
            }
        }
        ArrayList<Recipe> deps = new ArrayList<Recipe>();
        for (String name : metadata.getDependsOn()) {
            deps.add(new RefRecipe(this.getName(null), name));
        }
        ReferenceRecipe recipe = new ReferenceRecipe(this.getName(metadata.getId()), this.blueprintContainer, metadata, listenersRecipe, deps);
        return recipe;
    }

    private Recipe createServiceRecipe(ServiceMetadata serviceExport) {
        CollectionRecipe listenersRecipe = new CollectionRecipe(this.getName(null), ArrayList.class);
        if (serviceExport.getRegistrationListeners() != null) {
            for (RegistrationListener listener : serviceExport.getRegistrationListeners()) {
                listenersRecipe.add(this.createRecipe(listener));
            }
        }
        ArrayList<Recipe> deps = new ArrayList<Recipe>();
        for (String name : serviceExport.getDependsOn()) {
            deps.add(new RefRecipe(this.getName(null), name));
        }
        ServiceRecipe recipe = new ServiceRecipe(this.getName(serviceExport.getId()), this.blueprintContainer, serviceExport, this.getValue(serviceExport.getServiceComponent(), null), listenersRecipe, this.getServicePropertiesRecipe(serviceExport), deps);
        return recipe;
    }

    protected MapRecipe getServicePropertiesRecipe(ServiceMetadata metadata) {
        List<MapEntry> properties = metadata.getServiceProperties();
        if (properties != null) {
            MutableMapMetadata map = MetadataUtil.createMetadata(MutableMapMetadata.class);
            for (MapEntry e : properties) {
                map.addEntry(e);
            }
            return this.createMapRecipe(map);
        }
        return null;
    }

    private Object getBeanClass(BeanMetadata beanMetadata) {
        ExtendedBeanMetadata extBeanMetadata;
        if (beanMetadata instanceof ExtendedBeanMetadata && (extBeanMetadata = (ExtendedBeanMetadata)beanMetadata).getRuntimeClass() != null) {
            return extBeanMetadata.getRuntimeClass();
        }
        return beanMetadata.getClassName();
    }

    private BeanRecipe createBeanRecipe(BeanMetadata beanMetadata) {
        BeanRecipe recipe = new BeanRecipe(this.getName(beanMetadata.getId()), this.blueprintContainer, this.getBeanClass(beanMetadata));
        ArrayList<Recipe> deps = new ArrayList<Recipe>();
        for (String name : beanMetadata.getDependsOn()) {
            deps.add(new RefRecipe(this.getName(null), name));
        }
        recipe.setExplicitDependencies(deps);
        recipe.setPrototype(MetadataUtil.isPrototypeScope(beanMetadata));
        recipe.setInitMethod(beanMetadata.getInitMethod());
        recipe.setDestroyMethod(beanMetadata.getDestroyMethod());
        List<BeanArgument> beanArguments = beanMetadata.getArguments();
        if (beanArguments != null && !beanArguments.isEmpty()) {
            boolean hasIndex;
            boolean bl = hasIndex = beanArguments.get(0).getIndex() >= 0;
            if (hasIndex) {
                ArrayList<BeanArgument> beanArgumentsCopy = new ArrayList<BeanArgument>(beanArguments);
                Collections.sort(beanArgumentsCopy, MetadataUtil.BEAN_COMPARATOR);
                beanArguments = beanArgumentsCopy;
            }
            ArrayList<Object> arguments = new ArrayList<Object>();
            ArrayList<String> argTypes = new ArrayList<String>();
            for (BeanArgument argument : beanArguments) {
                Recipe value = this.getValue(argument.getValue(), null);
                arguments.add(value);
                argTypes.add(argument.getValueType());
            }
            recipe.setArguments(arguments);
            recipe.setArgTypes(argTypes);
            recipe.setReorderArguments(!hasIndex);
        }
        recipe.setFactoryMethod(beanMetadata.getFactoryMethod());
        if (beanMetadata.getFactoryComponent() != null) {
            recipe.setFactoryComponent(this.getValue(beanMetadata.getFactoryComponent(), null));
        }
        for (BeanProperty property : beanMetadata.getProperties()) {
            Recipe value = this.getValue(property.getValue(), null);
            recipe.setProperty(property.getName(), value);
        }
        return recipe;
    }

    private Recipe createRecipe(RegistrationListener listener) {
        BeanRecipe recipe = new BeanRecipe(this.getName(null), this.blueprintContainer, ServiceListener.class);
        recipe.setProperty("listener", this.getValue(listener.getListenerComponent(), null));
        if (listener.getRegistrationMethod() != null) {
            recipe.setProperty("registerMethod", listener.getRegistrationMethod());
        }
        if (listener.getUnregistrationMethod() != null) {
            recipe.setProperty("unregisterMethod", listener.getUnregistrationMethod());
        }
        recipe.setProperty("blueprintContainer", this.blueprintContainer);
        return recipe;
    }

    private Recipe createRecipe(ReferenceListener listener) {
        BeanRecipe recipe = new BeanRecipe(this.getName(null), this.blueprintContainer, AbstractServiceReferenceRecipe.Listener.class);
        recipe.setProperty("listener", this.getValue(listener.getListenerComponent(), null));
        recipe.setProperty("metadata", listener);
        recipe.setProperty("blueprintContainer", this.blueprintContainer);
        return recipe;
    }

    private Recipe getValue(Metadata v, Object groupingType) {
        if (v instanceof NullMetadata) {
            return null;
        }
        if (v instanceof ComponentMetadata) {
            return this.createRecipe((ComponentMetadata)v);
        }
        if (v instanceof ValueMetadata) {
            ValueMetadata stringValue = (ValueMetadata)v;
            Object type = stringValue.getType();
            type = type == null ? groupingType : type;
            ValueRecipe vr = new ValueRecipe(this.getName(null), stringValue, type);
            return vr;
        }
        if (v instanceof RefMetadata) {
            String componentName = ((RefMetadata)v).getComponentId();
            RefRecipe rr = new RefRecipe(this.getName(null), componentName);
            return rr;
        }
        if (v instanceof CollectionMetadata) {
            CollectionMetadata collectionMetadata = (CollectionMetadata)v;
            Class<?> cl = collectionMetadata.getCollectionClass();
            String type = collectionMetadata.getValueType();
            if (cl == Object[].class) {
                ArrayRecipe ar = new ArrayRecipe(this.getName(null), type);
                for (Metadata lv : collectionMetadata.getValues()) {
                    ar.add(this.getValue(lv, type));
                }
                return ar;
            }
            CollectionRecipe cr = new CollectionRecipe(this.getName(null), cl != null ? cl : ArrayList.class);
            for (Metadata lv : collectionMetadata.getValues()) {
                cr.add(this.getValue(lv, type));
            }
            return cr;
        }
        if (v instanceof MapMetadata) {
            return this.createMapRecipe((MapMetadata)v);
        }
        if (v instanceof PropsMetadata) {
            PropsMetadata mapValue = (PropsMetadata)v;
            MapRecipe mr = new MapRecipe(this.getName(null), Properties.class);
            for (MapEntry entry : mapValue.getEntries()) {
                Recipe key = this.getValue(entry.getKey(), String.class);
                Recipe val = this.getValue(entry.getValue(), String.class);
                mr.put(key, val);
            }
            return mr;
        }
        if (v instanceof IdRefMetadata) {
            String componentName = ((IdRefMetadata)v).getComponentId();
            IdRefRecipe rnr = new IdRefRecipe(this.getName(null), componentName);
            return rnr;
        }
        throw new IllegalStateException("Unsupported value: " + v.getClass().getName());
    }

    private MapRecipe createMapRecipe(MapMetadata mapValue) {
        String keyType = mapValue.getKeyType();
        String valueType = mapValue.getValueType();
        MapRecipe mr = new MapRecipe(this.getName(null), HashMap.class);
        for (MapEntry entry : mapValue.getEntries()) {
            Recipe key = this.getValue(entry.getKey(), keyType);
            Recipe val = this.getValue(entry.getValue(), valueType);
            mr.put(key, val);
        }
        return mr;
    }

    private String getName(String name) {
        if (name == null) {
            while (this.names.contains(name = "#recipe-" + ++this.nameCounter) || this.registry.containsComponentDefinition(name)) {
            }
        }
        this.names.add(name);
        return name;
    }
}

