/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.blueprint.container.BlueprintRepository;
import org.apache.geronimo.blueprint.di.CircularDependencyException;
import org.apache.geronimo.blueprint.di.Recipe;
import org.apache.geronimo.blueprint.di.RefRecipe;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraph.class);
    private BlueprintRepository repository;

    public DependencyGraph(BlueprintRepository repository) {
        this.repository = repository;
    }

    public LinkedHashMap<String, Recipe> getSortedRecipes(Collection<String> names) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (String name : names) {
            Object object = this.repository.getObject(name);
            if (object == null) {
                throw new NoSuchComponentException(name);
            }
            if (!(object instanceof Recipe)) continue;
            Recipe recipe = (Recipe)object;
            if (!recipe.getName().equals(name)) {
                throw new RuntimeException("Recipe '" + name + "' returned from the repository has name '" + name + "'");
            }
            this.createNode(name, recipe, nodes);
        }
        ArrayList<Node> sortedNodes = new ArrayList<Node>(nodes.size());
        LinkedList<Node> leafNodes = new LinkedList<Node>();
        for (Node n : nodes.values()) {
            if (n.referenceCount != 0) continue;
            if (n.references.size() == 0) {
                sortedNodes.add(n);
                continue;
            }
            leafNodes.add(n);
        }
        while (!leafNodes.isEmpty()) {
            Node node = (Node)leafNodes.removeFirst();
            sortedNodes.add(node);
            for (Node ref : node.references) {
                --ref.referenceCount;
                if (ref.referenceCount != 0) continue;
                leafNodes.add(ref);
            }
        }
        if (sortedNodes.size() != nodes.size()) {
            this.findCircuit((Node)nodes.values().iterator().next(), new ArrayList<Recipe>(nodes.size()));
            throw new RuntimeException("Internal Error: expected a CircularDependencyException");
        }
        LinkedHashMap<String, Recipe> sortedRecipes = new LinkedHashMap<String, Recipe>();
        for (Node node : sortedNodes) {
            sortedRecipes.put(node.name, node.recipe);
        }
        return sortedRecipes;
    }

    private void findCircuit(Node node, ArrayList<Recipe> stack) {
        if (stack.contains(node.recipe)) {
            ArrayList<Recipe> circularity = new ArrayList<Recipe>(stack.subList(stack.indexOf(node.recipe), stack.size()));
            Iterator<Recipe> iterator = circularity.iterator();
            while (iterator.hasNext()) {
                Recipe recipe = iterator.next();
                if (recipe == node.recipe || recipe.getName() != null) continue;
                iterator.remove();
            }
            circularity.add(node.recipe);
            throw new CircularDependencyException(circularity);
        }
        stack.add(node.recipe);
        for (Node reference : node.references) {
            this.findCircuit(reference, stack);
        }
    }

    private Node createNode(String name, Recipe recipe, Map<String, Node> nodes) {
        if (nodes.containsKey(name)) {
            Node node = nodes.get(name);
            if (node.recipe != recipe) {
                throw new RuntimeException("The name '" + name + "' is assigned to multiple recipies");
            }
            return node;
        }
        Node node = new Node();
        node.name = name;
        node.recipe = recipe;
        nodes.put(name, node);
        LinkedList<Recipe> constructorRecipes = new LinkedList<Recipe>(recipe.getConstructorDependencies());
        while (!constructorRecipes.isEmpty()) {
            Recipe nestedRecipe = constructorRecipes.removeFirst();
            if (nestedRecipe instanceof RefRecipe) {
                nestedRecipe = nestedRecipe.getDependencies().get(0);
                String nestedName = nestedRecipe.getName();
                Node nestedNode = this.createNode(nestedName, nestedRecipe, nodes);
                ++node.referenceCount;
                nestedNode.references.add(node);
                continue;
            }
            constructorRecipes.addAll(nestedRecipe.getDependencies());
        }
        return node;
    }

    private class Node {
        String name;
        Recipe recipe;
        final List<Node> references = new ArrayList<Node>();
        int referenceCount;

        private Node() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Node[").append(this.name);
            if (this.references.size() > 0) {
                buf.append(" <- ");
                Iterator<Node> iter = this.references.iterator();
                while (iter.hasNext()) {
                    buf.append(iter.next().name);
                    if (!iter.hasNext()) continue;
                    buf.append(", ");
                }
            }
            buf.append("]");
            return buf.toString();
        }
    }
}

