/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.jamon;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.RangeHolder;
import java.lang.reflect.Method;
import org.apache.fulcrum.yaafi.interceptor.jamon.JamonPerformanceMonitor;
import org.apache.fulcrum.yaafi.interceptor.util.MethodToStringBuilderImpl;

public class Jamon2PerformanceMonitorImpl
implements JamonPerformanceMonitor {
    private static final String MONITOR_LABEL = "ms.services";
    private static RangeHolder rangeHolder = Jamon2PerformanceMonitorImpl.createMSHolder();
    private boolean isActive;
    private Method method;
    private Monitor monitor;
    private long startTime;

    public Jamon2PerformanceMonitorImpl(String serviceName, Method method, Boolean isActive) {
        this.method = method;
        this.isActive = isActive;
    }

    public void start() {
        if (this.isActive) {
            MonitorFactory.setRangeDefault((String)MONITOR_LABEL, (RangeHolder)rangeHolder);
            this.startTime = System.currentTimeMillis();
            MethodToStringBuilderImpl methodToStringBuilder = new MethodToStringBuilderImpl(this.method, 0);
            String methodSignature = methodToStringBuilder.toString();
            this.monitor = MonitorFactory.getMonitor((String)methodSignature, (String)MONITOR_LABEL);
            this.monitor.start();
        }
    }

    public void stop() {
        if (this.isActive) {
            long duration = System.currentTimeMillis() - this.startTime;
            this.monitor.add((double)duration);
            this.monitor.stop();
        }
    }

    public void stop(Throwable throwable) {
        if (this.isActive) {
            this.monitor.add(-1.0);
            this.monitor.stop();
        }
    }

    public String createReport() throws Exception {
        return MonitorFactory.getRootMonitor().getReport();
    }

    private static RangeHolder createMSHolder() {
        RangeHolder result = new RangeHolder("<");
        result.add("Exceptions", 0.0);
        result.add("0_10ms", 10.0);
        result.add("10_20ms", 20.0);
        result.add("20_40ms", 40.0);
        result.add("40_80ms", 80.0);
        result.add("80_160ms", 160.0);
        result.add("160_320ms", 320.0);
        result.add("320_640ms", 640.0);
        result.add("640_1280ms", 1280.0);
        result.add("1280_2560ms", 2560.0);
        result.add("2560_5120ms", 5120.0);
        result.add("5120_10240ms", 10240.0);
        result.add("10240_20480ms", 20480.0);
        result.addLastHeader("20480ms_");
        return result;
    }
}

