/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.tools;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.flume.tools.FlumeTool;
import org.apache.flume.tools.FlumeToolType;

public class FlumeToolsMain
implements FlumeTool {
    public static void main(String[] args) throws Exception {
        new FlumeToolsMain().run(args);
    }

    private FlumeToolsMain() {
    }

    @Override
    public void run(String[] args) throws Exception {
        String error = "Expected name of tool and arguments for tool to be passed in on the command line. Please pass one of the following as arguments to this command: \n";
        StringBuilder builder = new StringBuilder(error);
        for (FlumeToolType type : FlumeToolType.values()) {
            builder.append(type.name()).append("\n");
        }
        if (args == null || args.length == 0) {
            System.out.println(builder.toString());
            System.exit(1);
        }
        String toolName = args[0];
        FlumeTool tool = null;
        for (FlumeToolType type : FlumeToolType.values()) {
            if (!toolName.equalsIgnoreCase(type.name())) continue;
            tool = type.getClassInstance().newInstance();
            break;
        }
        Preconditions.checkNotNull((Object)tool, (Object)("Cannot find tool matching " + toolName + ". Please select one of: \n " + FlumeToolType.getNames()));
        if (args.length == 1) {
            tool.run(new String[0]);
        } else {
            tool.run(Arrays.asList(args).subList(1, args.length).toArray(new String[0]));
        }
    }
}

