/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import java.net.URI;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.flume.node.ConfigurationSource;
import org.apache.flume.node.net.AuthorizationProvider;

public interface ConfigurationSourceFactory {
    public static ConfigurationSource getConfigurationSource(URI uri, AuthorizationProvider authorizationProvider, boolean verifyHost) {
        String protocol = uri.getScheme();
        ServiceLoader<ConfigurationSourceFactory> serviceLoader = ServiceLoader.load(ConfigurationSourceFactory.class, ConfigurationSourceFactory.class.getClassLoader());
        for (ConfigurationSourceFactory configurationSourceFactory : serviceLoader) {
            if (!configurationSourceFactory.getSchemes().contains(protocol)) continue;
            return configurationSourceFactory.createConfigurationSource(uri, authorizationProvider, verifyHost);
        }
        return null;
    }

    public List<String> getSchemes();

    public ConfigurationSource createConfigurationSource(URI var1, AuthorizationProvider var2, boolean var3);
}

