/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc;

public enum DatabaseType {
    OTHER("OTHER", null),
    DERBY("DERBY", "values(1)"),
    MYSQL("MYSQL", "select 1"),
    POSTGRESQL("POSTGRESQL", null),
    ORACLE("ORACLE", null);

    private final String name;
    private final String validationQuery;

    private DatabaseType(String name, String validationQuery) {
        this.name = name;
        this.validationQuery = validationQuery;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public static DatabaseType getByName(String dbName) {
        DatabaseType type = null;
        try {
            type = DatabaseType.valueOf(dbName.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            type = OTHER;
        }
        return type;
    }
}

