/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.ResourceInformationReflector;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorProcessSpecContainerResourcePriorityAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorProcessSpecContainerResourcePriorityAdapter.class);
    private final Map<TaskExecutorProcessSpec, PriorityAndResource> taskExecutorProcessSpecToPriorityAndResource;
    private final Map<Priority, TaskExecutorProcessSpec> priorityToTaskExecutorProcessSpec;
    private final Resource maxContainerResource;
    private final Map<String, Long> externalResourceConfigs;
    private int nextPriority = 1;

    TaskExecutorProcessSpecContainerResourcePriorityAdapter(Resource maxContainerResource, Map<String, Long> externalResourceConfigs) {
        this.maxContainerResource = (Resource)Preconditions.checkNotNull((Object)maxContainerResource);
        this.externalResourceConfigs = (Map)Preconditions.checkNotNull(externalResourceConfigs);
        this.taskExecutorProcessSpecToPriorityAndResource = new HashMap<TaskExecutorProcessSpec, PriorityAndResource>();
        this.priorityToTaskExecutorProcessSpec = new HashMap<Priority, TaskExecutorProcessSpec>();
        this.validateExternalResourceConfigs();
    }

    Optional<PriorityAndResource> getPriorityAndResource(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        this.tryAdaptAndAddTaskExecutorResourceSpecIfNotExist(taskExecutorProcessSpec);
        return Optional.ofNullable(this.taskExecutorProcessSpecToPriorityAndResource.get(taskExecutorProcessSpec));
    }

    Optional<TaskExecutorProcessSpecAndResource> getTaskExecutorProcessSpecAndResource(Priority priority) {
        TaskExecutorProcessSpec taskExecutorProcessSpec = this.priorityToTaskExecutorProcessSpec.get(priority);
        if (taskExecutorProcessSpec == null) {
            return Optional.empty();
        }
        PriorityAndResource priorityAndResource = this.taskExecutorProcessSpecToPriorityAndResource.get(taskExecutorProcessSpec);
        Preconditions.checkState((priorityAndResource != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)priority.equals((Object)priorityAndResource.getPriority()));
        return Optional.of(new TaskExecutorProcessSpecAndResource(taskExecutorProcessSpec, priorityAndResource.getResource()));
    }

    private void validateExternalResourceConfigs() {
        Map<String, Long> maxExternalResources = ResourceInformationReflector.INSTANCE.getExternalResources(this.maxContainerResource);
        for (Map.Entry<String, Long> entry : this.externalResourceConfigs.entrySet()) {
            String resourceName = entry.getKey();
            long configuredValue = entry.getValue();
            Preconditions.checkState((boolean)maxExternalResources.containsKey(resourceName), (String)"External resource %s is not supported by the Yarn cluster.", (Object[])new Object[]{resourceName});
            Preconditions.checkState((configuredValue <= maxExternalResources.get(resourceName) ? 1 : 0) != 0, (String)"Configured value for external resource %s (%s) exceeds the max limitation of the Yarn cluster (%s).", (Object[])new Object[]{resourceName, configuredValue, maxExternalResources.get(resourceName)});
        }
    }

    private void tryAdaptAndAddTaskExecutorResourceSpecIfNotExist(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        if (!this.taskExecutorProcessSpecToPriorityAndResource.containsKey(taskExecutorProcessSpec)) {
            this.tryAdaptResource(taskExecutorProcessSpec).ifPresent(resource -> {
                Priority priority = Priority.newInstance((int)this.nextPriority++);
                this.taskExecutorProcessSpecToPriorityAndResource.put(taskExecutorProcessSpec, new PriorityAndResource(priority, (Resource)resource));
                this.priorityToTaskExecutorProcessSpec.put(priority, taskExecutorProcessSpec);
            });
        }
    }

    private Optional<Resource> tryAdaptResource(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        Resource resource = Resource.newInstance((int)taskExecutorProcessSpec.getTotalProcessMemorySize().getMebiBytes(), (int)taskExecutorProcessSpec.getCpuCores().getValue().intValue());
        if (resource.getMemory() > this.maxContainerResource.getMemory() || resource.getVirtualCores() > this.maxContainerResource.getVirtualCores()) {
            LOG.warn("Requested container resource ({}) exceeds the max limitation of the Yarn cluster ({}). Will not allocate resource.", (Object)resource, (Object)this.maxContainerResource);
            return Optional.empty();
        }
        for (Map.Entry<String, Long> externalResource : this.externalResourceConfigs.entrySet()) {
            ResourceInformationReflector.INSTANCE.setResourceInformation(resource, externalResource.getKey(), externalResource.getValue());
        }
        return Optional.of(resource);
    }

    class TaskExecutorProcessSpecAndResource {
        private final TaskExecutorProcessSpec taskExecutorProcessSpec;
        private final Resource resource;

        private TaskExecutorProcessSpecAndResource(TaskExecutorProcessSpec taskExecutorProcessSpec, Resource resource) {
            this.taskExecutorProcessSpec = (TaskExecutorProcessSpec)Preconditions.checkNotNull((Object)taskExecutorProcessSpec);
            this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
        }

        TaskExecutorProcessSpec getTaskExecutorProcessSpec() {
            return this.taskExecutorProcessSpec;
        }

        Resource getResource() {
            return this.resource;
        }
    }

    class PriorityAndResource {
        private final Priority priority;
        private final Resource resource;

        private PriorityAndResource(Priority priority, Resource resource) {
            this.priority = (Priority)Preconditions.checkNotNull((Object)priority);
            this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
        }

        Priority getPriority() {
            return this.priority;
        }

        Resource getResource() {
            return this.resource;
        }
    }
}

