/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.windowing.sessionwindows;

import java.util.Collection;
import java.util.Random;

public class LongRandomGenerator
extends Random {
    static final long serialVersionUID = 32523525277L;

    public LongRandomGenerator(long seed) {
        super(seed);
    }

    public long randomLongBetween(long minInclusive, long maxExclusive) {
        long generatedValue;
        long bits;
        if (maxExclusive <= minInclusive) {
            throw new IllegalArgumentException(String.format("Error: min (found %s) must be < than max (found %s)!", minInclusive, maxExclusive));
        }
        long delta = maxExclusive - minInclusive;
        while ((bits = this.nextLong() << 1 >>> 1) - (generatedValue = bits % delta) + (delta - 1L) < 0L) {
        }
        return minInclusive + generatedValue;
    }

    public int choseRandomIndex(Collection<?> collection) {
        return this.nextInt(collection.size());
    }

    public <T> T chooseRandomElement(Collection<T> collection) {
        int choice = this.choseRandomIndex(collection);
        for (T key : collection) {
            if (choice == 0) {
                return key;
            }
            --choice;
        }
        return null;
    }
}

