/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.CoordVector;

public class PointInFormat
extends DelimitedInputFormat<Tuple2<Integer, CoordVector>> {
    private static final long serialVersionUID = 1L;
    private final List<Double> dimensionValues = new ArrayList<Double>();
    private double[] pointValues = new double[0];

    public Tuple2<Integer, CoordVector> readRecord(Tuple2<Integer, CoordVector> reuse, byte[] bytes, int offset, int numBytes) throws IOException {
        int limit = offset + numBytes;
        int id = -1;
        int value = 0;
        int fractionValue = 0;
        int fractionChars = 0;
        boolean negative = false;
        this.dimensionValues.clear();
        for (int pos = offset; pos < limit; ++pos) {
            if (bytes[pos] == 124) {
                if (id == -1) {
                    id = value;
                } else {
                    double v = (double)value + (double)fractionValue * Math.pow(10.0, -1 * (fractionChars - 1));
                    this.dimensionValues.add(negative ? -v : v);
                }
                value = 0;
                fractionValue = 0;
                fractionChars = 0;
                negative = false;
                continue;
            }
            if (bytes[pos] == 46) {
                fractionChars = 1;
                continue;
            }
            if (bytes[pos] == 45) {
                negative = true;
                continue;
            }
            if (fractionChars == 0) {
                value *= 10;
                value += bytes[pos] - 48;
                continue;
            }
            fractionValue *= 10;
            fractionValue += bytes[pos] - 48;
            ++fractionChars;
        }
        reuse.f0 = id;
        if (this.pointValues.length != this.dimensionValues.size()) {
            this.pointValues = new double[this.dimensionValues.size()];
        }
        for (int i = 0; i < this.pointValues.length; ++i) {
            this.pointValues[i] = this.dimensionValues.get(i);
        }
        reuse.f1 = new CoordVector(this.pointValues);
        return reuse;
    }
}

