/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.runtime;

import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryBackendCheckpointStorageAccess;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class StateBackendITCase
extends AbstractTestBase {
    @Test
    public void testStateBackendWithoutCheckpointing() throws Exception {
        StreamExecutionEnvironment see = StreamExecutionEnvironment.getExecutionEnvironment();
        see.setParallelism(1);
        see.getConfig().setRestartStrategy(RestartStrategies.noRestart());
        see.setStateBackend((StateBackend)new FailingStateBackend());
        see.fromElements((Object[])new Tuple2[]{new Tuple2((Object)"Hello", (Object)1)}).keyBy(new int[]{0}).map((MapFunction)new RichMapFunction<Tuple2<String, Integer>, String>(){
            private static final long serialVersionUID = 1L;

            public void open(Configuration parameters) throws Exception {
                super.open(parameters);
                this.getRuntimeContext().getState(new ValueStateDescriptor("Test", Integer.class));
            }

            public String map(Tuple2<String, Integer> value) throws Exception {
                return (String)value.f0;
            }
        }).print();
        try {
            see.execute();
            Assert.fail();
        }
        catch (JobExecutionException e) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)e, SuccessException.class).isPresent());
        }
    }

    static final class SuccessException
    extends IOException {
        private static final long serialVersionUID = -9218191172606739598L;

        SuccessException() {
        }
    }

    private static class FailingStateBackend
    implements StateBackend,
    CheckpointStorage {
        private static final long serialVersionUID = 1L;

        private FailingStateBackend() {
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
            return new MemoryBackendCheckpointStorageAccess(jobId, null, null, 1000000);
        }

        public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws IOException {
            throw new SuccessException();
        }

        public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier, @Nonnull Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
            throw new SuccessException();
        }
    }
}

